/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.eperson.EPerson;
import org.dspace.rest.Resource;
import org.dspace.rest.TokenHolder;
import org.dspace.rest.common.Status;
import org.dspace.rest.common.User;
import org.dspace.rest.exceptions.ContextException;

@Path(value="/")
public class RestIndex {
    private static Logger log = Logger.getLogger(RestIndex.class);
    @Context
    public static ServletContext servletContext;

    @GET
    @Produces(value={"text/html"})
    public String sayHtmlHello() {
        return "<html><title>DSpace REST - index</title><body><h1>DSpace REST API</h1>Server path: " + servletContext.getContextPath() + "<h2>Index</h2>" + "<ul>" + "<li>GET / - Return this page.</li>" + "<li>GET /test - Return the string \"REST api is running\" for testing purposes.</li>" + "<li>POST /login - Method for logging into the DSpace RESTful API. You must post User class. Example: {\"email\":\"test@dspace\",\"password\":\"pass\"}. Returns a token which must be included in future requests in the \"rest-dspace-token\" header.</li>" + "<li>POST /logout - Method for logging out of the DSpace RESTful API. The request must include the \"rest-dspace-token\" token</li> header." + "</ul>" + "<h2>Communities</h2>" + "<ul>" + "<li>GET /communities - Return an array of all communities in DSpace.</li>" + "<li>GET /communities/top-communities - Returns an array of all top-leve communities in DSpace.</li>" + "<li>GET /communities/{communityId} - Returns a community with the specified ID.</li>" + "<li>GET /communities/{communityId}/collections - Returns an array of collections of the specified community.</li>" + "<li>GET /communities/{communityId}/communities - Returns an array of subcommunities of the specified community.</li>" + "<li>POST /communities - Create a new top-level community. You must post a community.</li>" + "<li>POST /communities/{communityId}/collections - Create a new collection in the specified community. You must post a collection.</li>" + "<li>POST /communities/{communityId}/communities - Create a new subcommunity in the specified community. You must post a community.</li>" + "<li>PUT /communities/{communityId} - Update the specified community.</li>" + "<li>DELETE /communities/{communityId} - Delete the specified community.</li>" + "<li>DELETE /communities/{communityId}/collections/{collectionId} - Delete the specified collection in the specified community.</li>" + "<li>DELETE /communities/{communityId}/communities/{communityId2} - Delete the specified subcommunity (communityId2) in the specified community (communityId).</li>" + "</ul>" + "<h2>Collections</h2>" + "<ul>" + "<li>GET /collections - Return all DSpace collections in array.</li>" + "<li>GET /collections/{collectionId} - Return a collection with the specified ID.</li>" + "<li>GET /collections/{collectionId}/items - Return all items of the specified collection.</li>" + "<li>POST /collections/{collectionId}/items - Create an item in the specified collection. You must post an item.</li>" + "<li>POST /collections/find-collection - Find a collection by name.</li>" + "<li>PUT /collections/{collectionId} </li> - Update the specified collection. You must post a collection." + "<li>DELETE /collections/{collectionId} - Delete the specified collection from DSpace.</li>" + "<li>DELETE /collections/{collectionId}/items/{itemId} - Delete the specified item (itemId) in the specified collection (collectionId). </li>" + "</ul>" + "<h2>Items</h2>" + "<ul>" + "<li>GET /items - Return a list of items.</li>" + "<li>GET /items/{item id} - Return the specified item.</li>" + "<li>GET /items/{item id}/metadata - Return metadata of the specified item.</li>" + "<li>GET /items/{item id}/bitstreams - Return bitstreams of the specified item.</li>" + "<li>POST /items/find-by-metadata-field - Find items by the specified metadata value.</li>" + "<li>POST /items/{item id}/metadata - Add metadata to the specified item.</li>" + "<li>POST /items/{item id}/bitstreams - Add a bitstream to the specified item.</li>" + "<li>PUT /items/{item id}/metadata - Update metadata in the specified item.</li>" + "<li>DELETE /items/{item id} - Delete the specified item.</li>" + "<li>DELETE /items/{item id}/metadata - Clear metadata of the specified item.</li>" + "<li>DELETE /items/{item id}/bitstreams/{bitstream id} - Delete the specified bitstream of the specified item.</li>" + "</ul>" + "<h2>Bitstreams</h2>" + "<ul>" + "<li>GET /bitstreams - Return all bitstreams in DSpace.</li>" + "<li>GET /bitstreams/{bitstream id} - Return the specified bitstream.</li>" + "<li>GET /bitstreams/{bitstream id}/policy - Return policies of the specified bitstream.</li>" + "<li>GET /bitstreams/{bitstream id}/retrieve - Return the contents of the specified bitstream.</li>" + "<li>POST /bitstreams/{bitstream id}/policy - Add a policy to the specified bitstream.</li>" + "<li>PUT /bitstreams/{bitstream id}/data - Update the contents of the specified bitstream.</li>" + "<li>PUT /bitstreams/{bitstream id} - Update metadata of the specified bitstream.</li>" + "<li>DELETE /bitstreams/{bitstream id} - Delete the specified bitstream from DSpace.</li>" + "<li>DELETE /bitstreams/{bitstream id}/policy/{policy_id} - Delete the specified bitstream policy.</li>" + "</ul>" + "</body></html> ";
    }

    @GET
    @Path(value="/test")
    public String test() {
        return "REST api is running.";
    }

    @POST
    @Path(value="/login")
    @Consumes(value={"application/json", "application/xml"})
    public Response login(User user) {
        String token = TokenHolder.login((User)user);
        if (token == null) {
            log.info((Object)("REST Login Attempt failed for user: " + user.getEmail()));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        log.info((Object)("REST Login Success for user: " + user.getEmail()));
        return Response.ok((Object)token, (String)"text/plain").build();
    }

    @POST
    @Path(value="/logout")
    @Consumes(value={"application/json", "application/xml"})
    public Response logout(@Context HttpHeaders headers) {
        List list = headers.getRequestHeader(TokenHolder.TOKEN_HEADER);
        String token = null;
        boolean logout = false;
        EPerson ePerson = null;
        if (list != null) {
            token = (String)list.get(0);
            ePerson = TokenHolder.getEPerson((String)token);
            logout = TokenHolder.logout((String)token);
        }
        if (token == null || !logout) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (ePerson != null) {
            log.info((Object)("REST Logout: " + ePerson.getEmail()));
        }
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/status")
    @Consumes(value={"application/json", "application/xml"})
    public Status status(@Context HttpHeaders headers) throws UnsupportedEncodingException {
        org.dspace.core.Context context = null;
        try {
            context = Resource.createContext((EPerson)Resource.getUser((HttpHeaders)headers));
            EPerson ePerson = context.getCurrentUser();
            if (ePerson != null) {
                Status status;
                EPerson dbEPerson = EPerson.findByEmail((org.dspace.core.Context)context, (String)ePerson.getEmail());
                String token = Resource.getToken((HttpHeaders)headers);
                Status status2 = status = new Status(dbEPerson.getEmail(), dbEPerson.getFullName(), token);
                return status2;
            }
        }
        catch (ContextException e) {
            Resource.processException((String)("Status context error: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        catch (SQLException e) {
            Resource.processException((String)("Status eperson db lookup error: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            Resource.processException((String)("Status eperson authorize exception: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            context.abort();
        }
        return new Status();
    }
}

