/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest.common;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;
import org.dspace.content.ItemIterator;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.rest.common.Bitstream;
import org.dspace.rest.common.Community;
import org.dspace.rest.common.DSpaceObject;
import org.dspace.rest.common.Item;

@XmlRootElement(name="collection")
public class Collection
extends DSpaceObject {
    Logger log = Logger.getLogger(Collection.class);
    private Bitstream logo;
    private Community parentCommunity;
    private List<Community> parentCommunityList = new ArrayList();
    private List<Item> items = new ArrayList();
    private String license;
    private String copyrightText;
    private String introductoryText;
    private String shortDescription;
    private String sidebarText;
    private Integer numberItems;

    public Collection() {
    }

    public Collection(org.dspace.content.Collection collection, String expand, Context context, Integer limit, Integer offset) throws SQLException, WebApplicationException {
        super((org.dspace.content.DSpaceObject)collection);
        this.setup(collection, expand, context, limit, offset);
    }

    private void setup(org.dspace.content.Collection collection, String expand, Context context, Integer limit, Integer offset) throws SQLException {
        List<Object> expandFields = new ArrayList();
        if (expand != null) {
            expandFields = Arrays.asList(expand.split(","));
        }
        this.setCopyrightText(collection.getMetadata("copyright_text"));
        this.setIntroductoryText(collection.getMetadata("introductory_text"));
        this.setShortDescription(collection.getMetadata("short_description"));
        this.setSidebarText(collection.getMetadata("side_bar_text"));
        if (expandFields.contains("parentCommunityList") || expandFields.contains("all")) {
            org.dspace.content.Community[] parentCommunities;
            for (org.dspace.content.Community parentCommunity : parentCommunities = collection.getCommunities()) {
                this.addParentCommunityList(new Community(parentCommunity, null, context));
            }
        } else {
            this.addExpand("parentCommunityList");
        }
        if (expandFields.contains("parentCommunity") | expandFields.contains("all")) {
            org.dspace.content.Community parentCommunity = (org.dspace.content.Community)collection.getParentObject();
            this.setParentCommunity(new Community(parentCommunity, null, context));
        } else {
            this.addExpand("parentCommunity");
        }
        if (expandFields.contains("items") || expandFields.contains("all")) {
            ItemIterator childItems = limit != null && limit >= 0 && offset != null && offset >= 0 ? collection.getItems(limit, offset) : collection.getItems();
            this.items = new ArrayList();
            while (childItems.hasNext()) {
                org.dspace.content.Item item = childItems.next();
                if (!ItemService.isItemListedForUser((Context)context, (org.dspace.content.Item)item)) continue;
                this.items.add(new Item(item, null, context));
            }
        } else {
            this.addExpand("items");
        }
        if (expandFields.contains("license") || expandFields.contains("all")) {
            this.setLicense(collection.getLicense());
        } else {
            this.addExpand("license");
        }
        if (expandFields.contains("logo") || expandFields.contains("all")) {
            if (collection.getLogo() != null) {
                this.logo = new Bitstream(collection.getLogo(), null);
            }
        } else {
            this.addExpand("logo");
        }
        if (!expandFields.contains("all")) {
            this.addExpand("all");
        }
        this.setNumberItems(Integer.valueOf(collection.countItems()));
    }

    public Bitstream getLogo() {
        return this.logo;
    }

    public Integer getNumberItems() {
        return this.numberItems;
    }

    public void setNumberItems(Integer numberItems) {
        this.numberItems = numberItems;
    }

    public Community getParentCommunity() {
        return this.parentCommunity;
    }

    public void setParentCommunity(Community parentCommunity) {
        this.parentCommunity = parentCommunity;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public void setParentCommunityList(List<Community> parentCommunityList) {
        this.parentCommunityList = parentCommunityList;
    }

    public List<Community> getParentCommunityList() {
        return this.parentCommunityList;
    }

    public void addParentCommunityList(Community parentCommunity) {
        this.parentCommunityList.add(parentCommunity);
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getCopyrightText() {
        return this.copyrightText;
    }

    public void setCopyrightText(String copyrightText) {
        this.copyrightText = copyrightText;
    }

    public String getIntroductoryText() {
        return this.introductoryText;
    }

    public void setIntroductoryText(String introductoryText) {
        this.introductoryText = introductoryText;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getSidebarText() {
        return this.sidebarText;
    }

    public void setSidebarText(String sidebarText) {
        this.sidebarText = sidebarText;
    }
}

