/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest.common;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.core.Context;
import org.dspace.rest.common.Bitstream;
import org.dspace.rest.common.Collection;
import org.dspace.rest.common.DSpaceObject;

@XmlRootElement(name="community")
public class Community
extends DSpaceObject {
    private static Logger log = Logger.getLogger(Community.class);
    private Bitstream logo;
    private Community parentCommunity;
    private String copyrightText;
    private String introductoryText;
    private String shortDescription;
    private String sidebarText;
    private Integer countItems;
    private List<Community> subcommunities = new ArrayList();
    private List<Collection> collections = new ArrayList();

    public Community() {
    }

    public Community(org.dspace.content.Community community, String expand, Context context) throws SQLException, WebApplicationException {
        super((org.dspace.content.DSpaceObject)community);
        this.setup(community, expand, context);
    }

    private void setup(org.dspace.content.Community community, String expand, Context context) throws SQLException {
        List<Object> expandFields = new ArrayList();
        if (expand != null) {
            expandFields = Arrays.asList(expand.split(","));
        }
        this.setCopyrightText(community.getMetadata("copyright_text"));
        this.setIntroductoryText(community.getMetadata("introductory_text"));
        this.setShortDescription(community.getMetadata("short_description"));
        this.setSidebarText(community.getMetadata("side_bar_text"));
        this.setCountItems(Integer.valueOf(community.countItems()));
        if (expandFields.contains("parentCommunity") || expandFields.contains("all")) {
            org.dspace.content.Community parentCommunity = community.getParentCommunity();
            if (parentCommunity != null) {
                this.setParentCommunity(new Community(parentCommunity, null, context));
            }
        } else {
            this.addExpand("parentCommunity");
        }
        if (expandFields.contains("collections") || expandFields.contains("all")) {
            org.dspace.content.Collection[] collectionArray = community.getCollections();
            this.collections = new ArrayList();
            for (org.dspace.content.Collection collection : collectionArray) {
                if (AuthorizeManager.authorizeActionBoolean((Context)context, (org.dspace.content.DSpaceObject)collection, (int)0)) {
                    this.collections.add(new Collection(collection, null, context, null, null));
                    continue;
                }
                log.info((Object)("Omitted restricted collection: " + collection.getID() + " _ " + collection.getName()));
            }
        } else {
            this.addExpand("collections");
        }
        if (expandFields.contains("subCommunities") || expandFields.contains("all")) {
            org.dspace.content.Community[] communityArray = community.getSubcommunities();
            this.subcommunities = new ArrayList();
            for (org.dspace.content.Collection collection : communityArray) {
                if (AuthorizeManager.authorizeActionBoolean((Context)context, (org.dspace.content.DSpaceObject)collection, (int)0)) {
                    this.subcommunities.add(new Community((org.dspace.content.Community)collection, null, context));
                    continue;
                }
                log.info((Object)("Omitted restricted subCommunity: " + collection.getID() + " _ " + collection.getName()));
            }
        } else {
            this.addExpand("subCommunities");
        }
        if (expandFields.contains("logo") || expandFields.contains("all")) {
            if (community.getLogo() != null) {
                this.logo = new Bitstream(community.getLogo(), null);
            }
        } else {
            this.addExpand("logo");
        }
        if (!expandFields.contains("all")) {
            this.addExpand("all");
        }
    }

    public List<Collection> getCollections() {
        return this.collections;
    }

    public void setCollections(List<Collection> collections) {
        this.collections = collections;
    }

    public Integer getCountItems() {
        return this.countItems;
    }

    public void setCountItems(Integer countItems) {
        this.countItems = countItems;
    }

    public String getSidebarText() {
        return this.sidebarText;
    }

    public void setSidebarText(String sidebarText) {
        this.sidebarText = sidebarText;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getIntroductoryText() {
        return this.introductoryText;
    }

    public void setIntroductoryText(String introductoryText) {
        this.introductoryText = introductoryText;
    }

    public String getCopyrightText() {
        return this.copyrightText;
    }

    public void setCopyrightText(String copyrightText) {
        this.copyrightText = copyrightText;
    }

    public Community getParentCommunity() {
        return this.parentCommunity;
    }

    public void setParentCommunity(Community parentCommunity) {
        this.parentCommunity = parentCommunity;
    }

    public Bitstream getLogo() {
        return this.logo;
    }

    @XmlElement(name="subcommunities", required=true)
    public List<Community> getSubcommunities() {
        return this.subcommunities;
    }

    public void setSubcommunities(List<Community> subcommunities) {
        this.subcommunities = subcommunities;
    }
}

