/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.DSpaceObject;
import org.dspace.eperson.EPerson;
import org.dspace.rest.Resource;
import org.dspace.rest.common.Collection;
import org.dspace.rest.common.Community;
import org.dspace.rest.exceptions.ContextException;
import org.dspace.usage.UsageEvent;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/communities")
public class CommunitiesResource
extends Resource {
    private static Logger log = Logger.getLogger(CommunitiesResource.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{community_id}")
    @Produces(value={"application/json", "application/xml"})
    public Community getCommunity(@PathParam(value="community_id") Integer communityId, @QueryParam(value="expand") String expand, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Reading community(id=" + communityId + ")."));
        org.dspace.core.Context context = null;
        Community community = null;
        try {
            context = CommunitiesResource.createContext((EPerson)CommunitiesResource.getUser((HttpHeaders)headers));
            org.dspace.content.Community dspaceCommunity = this.findCommunity(context, communityId.intValue(), 0);
            this.writeStats((DSpaceObject)dspaceCommunity, UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
            community = new Community(dspaceCommunity, expand, context);
            context.complete();
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Could not read community(id=" + communityId + "), SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CommunitiesResource.processException((String)("Could not read community(id=" + communityId + "), ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.trace((Object)("Community(id=" + communityId + ") was successfully read."));
        return community;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json", "application/xml"})
    public Community[] getCommunities(@QueryParam(value="expand") String expand, @QueryParam(value="limit") @DefaultValue(value="100") Integer limit, @QueryParam(value="offset") @DefaultValue(value="0") Integer offset, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Reading all communities.(offset=" + offset + " ,limit=" + limit + ")."));
        org.dspace.core.Context context = null;
        ArrayList<Community> communities = null;
        try {
            context = CommunitiesResource.createContext((EPerson)CommunitiesResource.getUser((HttpHeaders)headers));
            org.dspace.content.Community[] dspaceCommunities = org.dspace.content.Community.findAll((org.dspace.core.Context)context);
            communities = new ArrayList<Community>();
            if (limit == null || limit < 0 || offset == null || offset < 0) {
                log.warn((Object)"Paging was badly set, using default values.");
                limit = 100;
                offset = 0;
            }
            for (int i = offset.intValue(); i < offset + limit && i < dspaceCommunities.length; ++i) {
                if (!AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, (DSpaceObject)dspaceCommunities[i], (int)0)) continue;
                Community community = new Community(dspaceCommunities[i], expand, context);
                this.writeStats((DSpaceObject)dspaceCommunities[i], UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
                communities.add(community);
            }
            context.complete();
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Could not read communities, SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CommunitiesResource.processException((String)("Could not read communities, ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.trace((Object)"All communities successfully read.");
        return communities.toArray(new Community[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/top-communities")
    @Produces(value={"application/json", "application/xml"})
    public Community[] getTopCommunities(@QueryParam(value="expand") String expand, @QueryParam(value="limit") @DefaultValue(value="20") Integer limit, @QueryParam(value="offset") @DefaultValue(value="0") Integer offset, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Reading all top communities.(offset=" + offset + " ,limit=" + limit + ")."));
        org.dspace.core.Context context = null;
        ArrayList<Community> communities = null;
        try {
            context = CommunitiesResource.createContext((EPerson)CommunitiesResource.getUser((HttpHeaders)headers));
            org.dspace.content.Community[] dspaceCommunities = org.dspace.content.Community.findAllTop((org.dspace.core.Context)context);
            communities = new ArrayList<Community>();
            if (limit == null || limit < 0 || offset == null || offset < 0) {
                log.warn((Object)"Pagging was badly set, using default values.");
                limit = 100;
                offset = 0;
            }
            for (int i = offset.intValue(); i < offset + limit && i < dspaceCommunities.length; ++i) {
                if (!AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, (DSpaceObject)dspaceCommunities[i], (int)0)) continue;
                Community community = new Community(dspaceCommunities[i], expand, context);
                this.writeStats((DSpaceObject)dspaceCommunities[i], UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
                communities.add(community);
            }
            context.complete();
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Could not read top communities, SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CommunitiesResource.processException((String)("Could not read top communities, ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.trace((Object)"All top communities successfully read.");
        return communities.toArray(new Community[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{community_id}/collections")
    @Produces(value={"application/json", "application/xml"})
    public Collection[] getCommunityCollections(@PathParam(value="community_id") Integer communityId, @QueryParam(value="expand") String expand, @QueryParam(value="limit") @DefaultValue(value="100") Integer limit, @QueryParam(value="offset") @DefaultValue(value="0") Integer offset, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Reading community(id=" + communityId + ") collections."));
        org.dspace.core.Context context = null;
        ArrayList<Collection> collections = null;
        try {
            context = CommunitiesResource.createContext((EPerson)CommunitiesResource.getUser((HttpHeaders)headers));
            org.dspace.content.Community dspaceCommunity = this.findCommunity(context, communityId.intValue(), 0);
            this.writeStats((DSpaceObject)dspaceCommunity, UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
            if (limit == null || limit < 0 || offset == null || offset < 0) {
                log.warn((Object)"Pagging was badly set, using default values.");
                limit = 100;
                offset = 0;
            }
            collections = new ArrayList<Collection>();
            org.dspace.content.Collection[] dspaceCollections = dspaceCommunity.getCollections();
            for (int i = offset.intValue(); i < offset + limit && i < dspaceCollections.length; ++i) {
                if (!AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, (DSpaceObject)dspaceCollections[i], (int)0)) continue;
                collections.add(new Collection(dspaceCollections[i], expand, context, Integer.valueOf(20), Integer.valueOf(0)));
                this.writeStats((DSpaceObject)dspaceCollections[i], UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
            }
            context.complete();
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Could not read community(id=" + communityId + ") collections, SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CommunitiesResource.processException((String)("Could not read community(id=" + communityId + ") collections, ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.trace((Object)("Community(id=" + communityId + ") collections were successfully read."));
        return collections.toArray(new Collection[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{community_id}/communities")
    @Produces(value={"application/json", "application/xml"})
    public Community[] getCommunityCommunities(@PathParam(value="community_id") Integer communityId, @QueryParam(value="expand") String expand, @QueryParam(value="limit") @DefaultValue(value="20") Integer limit, @QueryParam(value="offset") @DefaultValue(value="0") Integer offset, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Reading community(id=" + communityId + ") subcommunities."));
        org.dspace.core.Context context = null;
        ArrayList<Community> communities = null;
        try {
            context = CommunitiesResource.createContext((EPerson)CommunitiesResource.getUser((HttpHeaders)headers));
            org.dspace.content.Community dspaceCommunity = this.findCommunity(context, communityId.intValue(), 0);
            this.writeStats((DSpaceObject)dspaceCommunity, UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
            if (limit == null || limit < 0 || offset == null || offset < 0) {
                log.warn((Object)"Pagging was badly set, using default values.");
                limit = 100;
                offset = 0;
            }
            communities = new ArrayList<Community>();
            org.dspace.content.Community[] dspaceCommunities = dspaceCommunity.getSubcommunities();
            for (int i = offset.intValue(); i < offset + limit && i < dspaceCommunities.length; ++i) {
                if (!AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, (DSpaceObject)dspaceCommunities[i], (int)0)) continue;
                communities.add(new Community(dspaceCommunities[i], expand, context));
                this.writeStats((DSpaceObject)dspaceCommunities[i], UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
            }
            context.complete();
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Could not read community(id=" + communityId + ") subcommunities, SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CommunitiesResource.processException((String)("Could not read community(id=" + communityId + ") subcommunities, ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.trace((Object)("Community(id=" + communityId + ") subcommunities were successfully read."));
        return communities.toArray(new Community[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/json", "application/xml"})
    public Community createCommunity(Community community, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)"Creating community at top level.");
        org.dspace.core.Context context = null;
        Community retCommunity = null;
        try {
            context = CommunitiesResource.createContext((EPerson)CommunitiesResource.getUser((HttpHeaders)headers));
            if (!AuthorizeManager.isAdmin((org.dspace.core.Context)context)) {
                context.abort();
                String user = "anonymous";
                if (context.getCurrentUser() != null) {
                    user = context.getCurrentUser().getEmail();
                }
                log.error((Object)("User(" + user + ") has not permission to create community!"));
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            org.dspace.content.Community dspaceCommunity = org.dspace.content.Community.create(null, (org.dspace.core.Context)context);
            this.writeStats((DSpaceObject)dspaceCommunity, UsageEvent.Action.CREATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            dspaceCommunity.setMetadata("name", community.getName());
            dspaceCommunity.setMetadata("copyright_text", community.getCopyrightText());
            dspaceCommunity.setMetadata("introductory_text", community.getIntroductoryText());
            dspaceCommunity.setMetadata("short_description", community.getShortDescription());
            dspaceCommunity.setMetadata("side_bar_text", community.getSidebarText());
            dspaceCommunity.update();
            retCommunity = new Community(dspaceCommunity, "", context);
            context.complete();
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Could not create new top community, SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CommunitiesResource.processException((String)("Could not create new top community, ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            CommunitiesResource.processException((String)("Could not create new top community, AuthorizeException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info((Object)("Community at top level has been successfully created. Handle:" + retCommunity.getHandle()));
        return retCommunity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{community_id}/collections")
    @Consumes(value={"application/json", "application/xml"})
    public Collection addCommunityCollection(@PathParam(value="community_id") Integer communityId, Collection collection, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Adding collection into community(id=" + communityId + ")."));
        org.dspace.core.Context context = null;
        Collection retCollection = null;
        try {
            context = CommunitiesResource.createContext((EPerson)CommunitiesResource.getUser((HttpHeaders)headers));
            org.dspace.content.Community dspaceCommunity = this.findCommunity(context, communityId.intValue(), 1);
            this.writeStats((DSpaceObject)dspaceCommunity, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            org.dspace.content.Collection dspaceCollection = dspaceCommunity.createCollection();
            dspaceCollection.setLicense(collection.getLicense());
            dspaceCollection.setMetadata("name", collection.getName());
            dspaceCollection.setMetadata("copyright_text", collection.getCopyrightText());
            dspaceCollection.setMetadata("introductory_text", collection.getIntroductoryText());
            dspaceCollection.setMetadata("short_description", collection.getShortDescription());
            dspaceCollection.setMetadata("side_bar_text", collection.getSidebarText());
            dspaceCollection.setLicense(collection.getLicense());
            dspaceCollection.update();
            dspaceCommunity.update();
            retCollection = new Collection(dspaceCollection, "", context, Integer.valueOf(100), Integer.valueOf(0));
            context.complete();
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Could not add collection into community(id=" + communityId + "), SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            CommunitiesResource.processException((String)("Could not add collection into community(id=" + communityId + "), AuthorizeException. Message:" + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CommunitiesResource.processException((String)("Could not add collection into community(id=" + communityId + "), ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info((Object)("Collection was successfully added into community(id=" + communityId + "). Collection handle=" + retCollection.getHandle()));
        return retCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{community_id}/communities")
    @Consumes(value={"application/json", "application/xml"})
    public Community addCommunityCommunity(@PathParam(value="community_id") Integer communityId, Community community, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Add subcommunity into community(id=" + communityId + ")."));
        org.dspace.core.Context context = null;
        Community retCommunity = null;
        try {
            context = CommunitiesResource.createContext((EPerson)CommunitiesResource.getUser((HttpHeaders)headers));
            org.dspace.content.Community dspaceParentCommunity = this.findCommunity(context, communityId.intValue(), 1);
            this.writeStats((DSpaceObject)dspaceParentCommunity, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            org.dspace.content.Community dspaceCommunity = org.dspace.content.Community.create((org.dspace.content.Community)dspaceParentCommunity, (org.dspace.core.Context)context);
            dspaceCommunity.setMetadata("name", community.getName());
            dspaceCommunity.setMetadata("copyright_text", community.getCopyrightText());
            dspaceCommunity.setMetadata("introductory_text", community.getIntroductoryText());
            dspaceCommunity.setMetadata("short_description", community.getShortDescription());
            dspaceCommunity.setMetadata("side_bar_text", community.getSidebarText());
            dspaceCommunity.update();
            dspaceParentCommunity.update();
            retCommunity = new Community(dspaceCommunity, "", context);
            context.complete();
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Could not add subcommunity into community(id=" + communityId + "), SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            CommunitiesResource.processException((String)("Could not add subcommunity into community(id=" + communityId + "), AuthorizeException. Message:" + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CommunitiesResource.processException((String)("Could not add subcommunity into community(id=" + communityId + "), ContextException. Message:" + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info((Object)("Subcommunity was successfully added in community(id=" + communityId + ")."));
        return retCommunity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/{community_id}")
    @Consumes(value={"application/json", "application/xml"})
    public Response updateCommunity(@PathParam(value="community_id") Integer communityId, Community community, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Updating community(id=" + communityId + ")."));
        org.dspace.core.Context context = null;
        try {
            context = CommunitiesResource.createContext((EPerson)CommunitiesResource.getUser((HttpHeaders)headers));
            org.dspace.content.Community dspaceCommunity = this.findCommunity(context, communityId.intValue(), 1);
            this.writeStats((DSpaceObject)dspaceCommunity, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            dspaceCommunity.setMetadata("name", community.getName());
            dspaceCommunity.setMetadata("copyright_text", community.getCopyrightText());
            dspaceCommunity.setMetadata("introductory_text", community.getIntroductoryText());
            dspaceCommunity.setMetadata("short_description", community.getShortDescription());
            dspaceCommunity.setMetadata("side_bar_text", community.getSidebarText());
            dspaceCommunity.update();
            context.complete();
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Could not update community(id=" + communityId + "), AuthorizeException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CommunitiesResource.processException((String)("Could not update community(id=" + communityId + "), ContextException Message:" + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            CommunitiesResource.processException((String)("Could not update community(id=" + communityId + "), AuthorizeException. Message:" + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info((Object)("Community(id=" + communityId + ") has been successfully updated."));
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{community_id}")
    public Response deleteCommunity(@PathParam(value="community_id") Integer communityId, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Deleting community(id=" + communityId + ")."));
        org.dspace.core.Context context = null;
        try {
            context = CommunitiesResource.createContext((EPerson)CommunitiesResource.getUser((HttpHeaders)headers));
            org.dspace.content.Community community = this.findCommunity(context, communityId.intValue(), 2);
            this.writeStats((DSpaceObject)community, UsageEvent.Action.DELETE, user_ip, user_agent, xforwardedfor, headers, request, context);
            community.delete();
            context.complete();
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Could not delete community(id=" + communityId + "), SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            CommunitiesResource.processException((String)("Could not delete community(id=" + communityId + "), AuthorizeException. Message:" + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        catch (IOException e) {
            CommunitiesResource.processException((String)("Could not delete community(id=" + communityId + "), IOException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CommunitiesResource.processException((String)("Could not delete community(id=" + communityId + "), ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info((Object)("Community(id=" + communityId + ") was successfully deleted."));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{community_id}/collections/{collection_id}")
    public Response deleteCommunityCollection(@PathParam(value="community_id") Integer communityId, @PathParam(value="collection_id") Integer collectionId, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Deleting collection(id=" + collectionId + ") in community(id=" + communityId + ")."));
        org.dspace.core.Context context = null;
        try {
            context = CommunitiesResource.createContext((EPerson)CommunitiesResource.getUser((HttpHeaders)headers));
            org.dspace.content.Community community = this.findCommunity(context, communityId.intValue(), 1);
            org.dspace.content.Collection collection = null;
            for (org.dspace.content.Collection dspaceCollection : community.getAllCollections()) {
                if (dspaceCollection.getID() != collectionId.intValue()) continue;
                collection = dspaceCollection;
                break;
            }
            if (collection == null) {
                context.abort();
                log.warn((Object)("Collection(id=" + collectionId + ") was not found!"));
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            if (!AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, collection, (int)4)) {
                context.abort();
                if (context.getCurrentUser() != null) {
                    log.error((Object)("User(" + context.getCurrentUser().getEmail() + ") has not permission to delete collection!"));
                } else {
                    log.error((Object)"User(anonymous) has not permission to delete collection!");
                }
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            this.writeStats((DSpaceObject)community, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            this.writeStats((DSpaceObject)collection, UsageEvent.Action.DELETE, user_ip, user_agent, xforwardedfor, headers, request, context);
            community.removeCollection(collection);
            context.complete();
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Could not delete collection(id=" + collectionId + ") in community(id=" + communityId + "), SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            CommunitiesResource.processException((String)("Could not delete collection(id=" + collectionId + ") in community(id=" + communityId + "), AuthorizeException. Message:" + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        catch (IOException e) {
            CommunitiesResource.processException((String)("Could not delete collection(id=" + collectionId + ") in community(id=" + communityId + "), IOException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CommunitiesResource.processException((String)("Could not delete collection(id=" + collectionId + ") in community(id=" + communityId + "), ContextExcpetion. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info((Object)("Collection(id=" + collectionId + ") in community(id=" + communityId + ") was successfully deleted."));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{community_id}/communities/{community_id2}")
    public Response deleteCommunityCommunity(@PathParam(value="community_id") Integer parentCommunityId, @PathParam(value="community_id2") Integer subcommunityId, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Deleting community(id=" + parentCommunityId + ")."));
        org.dspace.core.Context context = null;
        try {
            context = CommunitiesResource.createContext((EPerson)CommunitiesResource.getUser((HttpHeaders)headers));
            org.dspace.content.Community parentCommunity = this.findCommunity(context, parentCommunityId.intValue(), 1);
            org.dspace.content.Community subcommunity = null;
            for (org.dspace.content.Community dspaceCommunity : parentCommunity.getSubcommunities()) {
                if (dspaceCommunity.getID() != subcommunityId.intValue()) continue;
                subcommunity = dspaceCommunity;
                break;
            }
            if (subcommunity == null) {
                context.abort();
                log.warn((Object)("Subcommunity(id=" + subcommunityId + ") in community(id=" + ") was not found!"));
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            if (!AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, subcommunity, (int)4)) {
                context.abort();
                if (context.getCurrentUser() != null) {
                    log.error((Object)("User(" + context.getCurrentUser().getEmail() + ") has not permission to delete community!"));
                } else {
                    log.error((Object)"User(anonymous) has not permission to delete community!");
                }
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            this.writeStats((DSpaceObject)parentCommunity, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            this.writeStats((DSpaceObject)subcommunity, UsageEvent.Action.DELETE, user_ip, user_agent, xforwardedfor, headers, request, context);
            parentCommunity.removeSubcommunity(subcommunity);
            context.complete();
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Could not delete subcommunity(id=" + subcommunityId + ") in community(id=" + parentCommunityId + "), SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            CommunitiesResource.processException((String)("Could not delete subcommunity(id=" + subcommunityId + ") in community(id=" + parentCommunityId + "), AuthorizeException. Message:" + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        catch (IOException e) {
            CommunitiesResource.processException((String)("Could not delete subcommunity(id=" + subcommunityId + ") in community(id=" + parentCommunityId + "), IOException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CommunitiesResource.processException((String)("Could not delete subcommunity(id=" + subcommunityId + ") in community(id=" + parentCommunityId + "), ContextExcpetion. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info((Object)("Subcommunity(id=" + subcommunityId + ") from community(id=" + parentCommunityId + ") was successfully deleted."));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private org.dspace.content.Community findCommunity(org.dspace.core.Context context, int id, int action) throws WebApplicationException {
        org.dspace.content.Community community = null;
        try {
            community = org.dspace.content.Community.find((org.dspace.core.Context)context, (int)id);
            if (community == null) {
                context.abort();
                log.warn((Object)("Community(id=" + id + ") was not found!"));
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            if (!AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, (DSpaceObject)community, (int)action)) {
                context.abort();
                if (context.getCurrentUser() != null) {
                    log.error((Object)("User(" + context.getCurrentUser().getEmail() + ") has not permission to " + this.getActionString(action) + " community!"));
                } else {
                    log.error((Object)("User(anonymous) has not permission to " + this.getActionString(action) + " community!"));
                }
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Something get wrong while finding community(id=" + id + "). SQLException, Message:" + e), (org.dspace.core.Context)context);
        }
        return community;
    }
}

