/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.eperson.EPerson;
import org.dspace.rest.TokenHolder;
import org.dspace.rest.exceptions.ContextException;
import org.dspace.services.model.Event;
import org.dspace.usage.UsageEvent;
import org.dspace.utils.DSpace;

public class Resource {
    @Context
    public static ServletContext servletContext;
    private static Logger log;
    private static final boolean writeStatistics;

    public static String getServletContextPath() {
        return servletContext.getContextPath();
    }

    protected static org.dspace.core.Context createContext(EPerson person) throws ContextException {
        org.dspace.core.Context context = null;
        try {
            context = new org.dspace.core.Context();
            context.getDBConnection().setAutoCommit(false);
            if (person != null) {
                context.setCurrentUser(person);
            }
            return context;
        }
        catch (SQLException e) {
            if (context != null && context.isValid()) {
                context.abort();
            }
            throw new ContextException("Could not create context, SQLException. Message: " + e, (Exception)e);
        }
    }

    protected void writeStats(DSpaceObject dspaceObject, UsageEvent.Action action, String user_ip, String user_agent, String xforwardedfor, HttpHeaders headers, HttpServletRequest request, org.dspace.core.Context context) {
        if (!writeStatistics) {
            return;
        }
        if (user_ip == null || user_ip.length() == 0) {
            new DSpace().getEventService().fireEvent((Event)new UsageEvent(action, request, context, dspaceObject));
        } else {
            new DSpace().getEventService().fireEvent((Event)new UsageEvent(action, user_ip, user_agent, xforwardedfor, context, dspaceObject));
        }
        log.debug((Object)"fired event");
    }

    protected static void processException(String message, org.dspace.core.Context context) throws WebApplicationException {
        if (context != null && context.isValid()) {
            context.abort();
        }
        log.error((Object)message);
        throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
    }

    protected void processFinally(org.dspace.core.Context context) throws WebApplicationException {
        if (context != null && context.isValid()) {
            context.abort();
            log.error((Object)"Something get wrong. Aborting context in finally statement.");
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected String[] mySplit(String key) {
        ArrayList<String> list = new ArrayList<String>();
        int prev = 0;
        for (int i = 0; i < key.length(); ++i) {
            if (key.charAt(i) == '.') {
                list.add(key.substring(prev, i));
                prev = i + 1;
                continue;
            }
            if (i + 1 != key.length()) continue;
            list.add(key.substring(prev, i + 1));
        }
        if (list.size() == 2) {
            list.add(null);
        }
        return list.toArray(new String[0]);
    }

    protected String getActionString(int action) {
        String actionStr;
        switch (action) {
            case 0: {
                actionStr = "read";
                break;
            }
            case 1: {
                actionStr = "write";
                break;
            }
            case 2: {
                actionStr = "delete";
                break;
            }
            case 4: {
                actionStr = "remove";
                break;
            }
            case 3: {
                actionStr = "add";
                break;
            }
            default: {
                actionStr = "(?action?)";
            }
        }
        return actionStr;
    }

    protected static EPerson getUser(HttpHeaders headers) {
        List list = headers.getRequestHeader(TokenHolder.TOKEN_HEADER);
        String token = null;
        if (list != null && list.size() > 0) {
            token = (String)list.get(0);
            return TokenHolder.getEPerson((String)token);
        }
        return null;
    }

    protected static String getToken(HttpHeaders headers) {
        List list = headers.getRequestHeader(TokenHolder.TOKEN_HEADER);
        String token = null;
        if (list != null && list.size() > 0) {
            token = (String)list.get(0);
            return token;
        }
        return null;
    }

    static {
        log = Logger.getLogger(Resource.class);
        writeStatistics = ConfigurationManager.getBooleanProperty((String)"rest", (String)"stats", (boolean)false);
    }
}

