/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest;

import java.sql.SQLException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.eperson.EPerson;
import org.dspace.handle.HandleManager;
import org.dspace.rest.Resource;
import org.dspace.rest.common.Collection;
import org.dspace.rest.common.Community;
import org.dspace.rest.common.DSpaceObject;
import org.dspace.rest.common.Item;
import org.dspace.rest.exceptions.ContextException;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/handle")
public class HandleResource
extends Resource {
    private static Logger log = Logger.getLogger(HandleResource.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{prefix}/{suffix}")
    @Produces(value={"application/json", "application/xml"})
    public DSpaceObject getObject(@PathParam(value="prefix") String prefix, @PathParam(value="suffix") String suffix, @QueryParam(value="expand") String expand, @Context HttpHeaders headers) throws WebApplicationException {
        org.dspace.core.Context context = null;
        DSpaceObject result = null;
        try {
            context = HandleResource.createContext((EPerson)HandleResource.getUser((HttpHeaders)headers));
            org.dspace.content.DSpaceObject dso = HandleManager.resolveToObject((org.dspace.core.Context)context, (String)(prefix + "/" + suffix));
            if (dso == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            log.info((Object)("DSO Lookup by handle: [" + prefix + "] / [" + suffix + "] got result of: " + dso.getTypeText() + "_" + dso.getID()));
            if (AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, (org.dspace.content.DSpaceObject)dso, (int)0)) {
                switch (dso.getType()) {
                    case 4: {
                        result = new Community((org.dspace.content.Community)dso, expand, context);
                        break;
                    }
                    case 3: {
                        result = new Collection((org.dspace.content.Collection)dso, expand, context, null, null);
                        break;
                    }
                    case 2: {
                        result = new Item((org.dspace.content.Item)dso, expand, context);
                        break;
                    }
                    default: {
                        result = new DSpaceObject(dso);
                        break;
                    }
                }
            } else {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            context.complete();
        }
        catch (SQLException e) {
            HandleResource.processException((String)("Could not read handle(" + prefix + "/" + suffix + "), SQLException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            HandleResource.processException((String)("Could not read handle(" + prefix + "/" + suffix + "), ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        return result;
    }
}

