/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest.common;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;
import org.dspace.content.Bundle;
import org.dspace.rest.common.CheckSum;
import org.dspace.rest.common.DSpaceObject;
import org.dspace.rest.common.ResourcePolicy;

@XmlRootElement(name="bitstream")
public class Bitstream
extends DSpaceObject {
    Logger log = Logger.getLogger(Bitstream.class);
    private String bundleName;
    private String description;
    private String format;
    private String mimeType;
    private Long sizeBytes;
    private DSpaceObject parentObject;
    private String retrieveLink;
    private CheckSum checkSum;
    private Integer sequenceId;
    private ResourcePolicy[] policies = null;

    public Bitstream() {
    }

    public Bitstream(org.dspace.content.Bitstream bitstream, String expand) throws SQLException {
        super((org.dspace.content.DSpaceObject)bitstream);
        this.setup(bitstream, expand);
    }

    public void setup(org.dspace.content.Bitstream bitstream, String expand) throws SQLException {
        List<Object> expandFields = new ArrayList();
        if (expand != null) {
            expandFields = Arrays.asList(expand.split(","));
        }
        if (bitstream.getBundles() != null & bitstream.getBundles().length >= 0 && bitstream.getParentObject().getType() == 2) {
            this.bundleName = bitstream.getBundles()[0].getName();
        }
        this.description = bitstream.getDescription();
        this.format = bitstream.getFormatDescription();
        this.sizeBytes = bitstream.getSize();
        this.retrieveLink = "/bitstreams/" + bitstream.getID() + "/retrieve";
        this.mimeType = bitstream.getFormat().getMIMEType();
        this.sequenceId = bitstream.getSequenceID();
        CheckSum checkSum = new CheckSum();
        checkSum.setCheckSumAlgorith(bitstream.getChecksumAlgorithm());
        checkSum.setValue(bitstream.getChecksum());
        this.setCheckSum(checkSum);
        if (expandFields.contains("parent") || expandFields.contains("all")) {
            this.parentObject = new DSpaceObject(bitstream.getParentObject());
        } else {
            this.addExpand("parent");
        }
        if (expandFields.contains("policies") || expandFields.contains("all")) {
            Bundle[] bundles;
            ArrayList<ResourcePolicy> tempPolicies = new ArrayList<ResourcePolicy>();
            for (Bundle bundle : bundles = bitstream.getBundles()) {
                List bitstreamsPolicies = bundle.getBitstreamPolicies();
                for (org.dspace.authorize.ResourcePolicy policy : bitstreamsPolicies) {
                    if (policy.getResourceID() != this.getId().intValue()) continue;
                    tempPolicies.add(new ResourcePolicy(policy));
                }
            }
            this.policies = tempPolicies.toArray(new ResourcePolicy[0]);
        } else {
            this.addExpand("policies");
        }
        if (!expandFields.contains("all")) {
            this.addExpand("all");
        }
    }

    public Integer getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(Integer sequenceId) {
        this.sequenceId = sequenceId;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setSizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
    }

    public void setParentObject(DSpaceObject parentObject) {
        this.parentObject = parentObject;
    }

    public void setRetrieveLink(String retrieveLink) {
        this.retrieveLink = retrieveLink;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFormat() {
        return this.format;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    public String getRetrieveLink() {
        return this.retrieveLink;
    }

    public DSpaceObject getParentObject() {
        return this.parentObject;
    }

    public CheckSum getCheckSum() {
        return this.checkSum;
    }

    public void setCheckSum(CheckSum checkSum) {
        this.checkSum = checkSum;
    }

    public ResourcePolicy[] getPolicies() {
        return this.policies;
    }

    public void setPolicies(ResourcePolicy[] policies) {
        this.policies = policies;
    }
}

