/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest.common;

import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.dspace.rest.common.ResourcePolicy;

@XmlRootElement(name="resourcepolicy")
public class ResourcePolicy {
    private Integer id;
    private Action action;
    private Integer epersonId;
    private Integer groupId;
    private Integer resourceId;
    private String resourceType;
    private String rpDescription;
    private String rpName;
    private String rpType;
    private Date startDate;
    private Date endDate;

    public ResourcePolicy() {
    }

    public ResourcePolicy(org.dspace.authorize.ResourcePolicy dspacePolicy) {
        this.id = dspacePolicy.getID();
        switch (dspacePolicy.getAction()) {
            case 0: {
                this.action = Action.READ;
                break;
            }
            case 1: {
                this.action = Action.WRITE;
                break;
            }
            case 2: {
                this.action = Action.DELETE;
            }
        }
        this.epersonId = dspacePolicy.getEPersonID();
        this.groupId = dspacePolicy.getGroupID();
        this.resourceId = dspacePolicy.getResourceID();
        this.rpDescription = dspacePolicy.getRpDescription();
        this.rpName = dspacePolicy.getRpName();
        this.rpType = dspacePolicy.getRpType();
        this.startDate = dspacePolicy.getStartDate();
        this.endDate = dspacePolicy.getEndDate();
        switch (dspacePolicy.getResourceType()) {
            case 0: {
                this.resourceType = "bitstream";
                break;
            }
            case 2: {
                this.resourceType = "item";
                break;
            }
            case 3: {
                this.resourceType = "collection";
                break;
            }
            case 4: {
                this.resourceType = "community";
                break;
            }
            case 1: {
                this.resourceType = "bundle";
                break;
            }
            default: {
                this.resourceType = "";
            }
        }
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Action getAction() {
        return this.action;
    }

    @JsonIgnore
    public int getActionInt() {
        switch (1.$SwitchMap$org$dspace$rest$common$ResourcePolicy$Action[this.action.ordinal()]) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return 0;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public Integer getEpersonId() {
        return this.epersonId;
    }

    public void setEpersonId(Integer epersonId) {
        this.epersonId = epersonId;
    }

    public Integer getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Integer groupId) {
        this.groupId = groupId;
    }

    public Integer getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(Integer resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getRpDescription() {
        return this.rpDescription;
    }

    public void setRpDescription(String rpDescription) {
        this.rpDescription = rpDescription;
    }

    public String getRpName() {
        return this.rpName;
    }

    public void setRpName(String rpName) {
        this.rpName = rpName;
    }

    public String getRpType() {
        return this.rpType;
    }

    public void setRpType(String rpType) {
        this.rpType = rpType;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
}

