/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest.common;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.ws.rs.WebApplicationException;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.rest.common.Bitstream;
import org.dspace.rest.common.Community;
import org.dspace.rest.common.DSpaceObject;
import org.dspace.rest.common.Item;

@XmlRootElement(name="collection")
public class Collection
extends DSpaceObject {
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    Logger log = Logger.getLogger(Collection.class);
    private Bitstream logo;
    private Community parentCommunity;
    private List<Community> parentCommunityList = new ArrayList();
    private List<Item> items = new ArrayList();
    private String license;
    private String copyrightText;
    private String introductoryText;
    private String shortDescription;
    private String sidebarText;
    private Integer numberItems;

    public Collection() {
    }

    public Collection(org.dspace.content.Collection collection, ServletContext servletContext, String expand, Context context, Integer limit, Integer offset) throws SQLException, WebApplicationException {
        super((org.dspace.content.DSpaceObject)collection, servletContext);
        this.setup(collection, servletContext, expand, context, limit, offset);
    }

    private void setup(org.dspace.content.Collection collection, ServletContext servletContext, String expand, Context context, Integer limit, Integer offset) throws SQLException {
        List<Object> expandFields = new ArrayList();
        if (expand != null) {
            expandFields = Arrays.asList(expand.split(","));
        }
        this.setCopyrightText(this.collectionService.getMetadata((org.dspace.content.DSpaceObject)collection, "copyright_text"));
        this.setIntroductoryText(this.collectionService.getMetadata((org.dspace.content.DSpaceObject)collection, "introductory_text"));
        this.setShortDescription(this.collectionService.getMetadata((org.dspace.content.DSpaceObject)collection, "short_description"));
        this.setSidebarText(this.collectionService.getMetadata((org.dspace.content.DSpaceObject)collection, "side_bar_text"));
        if (expandFields.contains("parentCommunityList") || expandFields.contains("all")) {
            List parentCommunities = collection.getCommunities();
            for (org.dspace.content.Community parentCommunity : parentCommunities) {
                this.addParentCommunityList(new Community(parentCommunity, servletContext, null, context));
            }
        } else {
            this.addExpand("parentCommunityList");
        }
        if (expandFields.contains("parentCommunity") | expandFields.contains("all")) {
            org.dspace.content.Community parentCommunity = (org.dspace.content.Community)this.collectionService.getParentObject(context, (org.dspace.content.DSpaceObject)collection);
            this.setParentCommunity(new Community(parentCommunity, servletContext, null, context));
        } else {
            this.addExpand("parentCommunity");
        }
        if (expandFields.contains("items") || expandFields.contains("all")) {
            Iterator childItems = this.itemService.findByCollection(context, collection, limit, offset);
            this.items = new ArrayList();
            while (childItems.hasNext()) {
                org.dspace.content.Item item = (org.dspace.content.Item)childItems.next();
                if (!this.itemService.isItemListedForUser(context, item)) continue;
                this.items.add(new Item(item, servletContext, null, context));
            }
        } else {
            this.addExpand("items");
        }
        if (expandFields.contains("license") || expandFields.contains("all")) {
            this.setLicense(this.collectionService.getLicense(collection));
        } else {
            this.addExpand("license");
        }
        if (expandFields.contains("logo") || expandFields.contains("all")) {
            if (collection.getLogo() != null) {
                this.logo = new Bitstream(collection.getLogo(), servletContext, null, context);
            }
        } else {
            this.addExpand("logo");
        }
        if (!expandFields.contains("all")) {
            this.addExpand("all");
        }
        this.setNumberItems(Integer.valueOf(this.itemService.countItems(context, collection)));
    }

    public Bitstream getLogo() {
        return this.logo;
    }

    public Integer getNumberItems() {
        return this.numberItems;
    }

    public void setNumberItems(Integer numberItems) {
        this.numberItems = numberItems;
    }

    public Community getParentCommunity() {
        return this.parentCommunity;
    }

    public void setParentCommunity(Community parentCommunity) {
        this.parentCommunity = parentCommunity;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public void setParentCommunityList(List<Community> parentCommunityList) {
        this.parentCommunityList = parentCommunityList;
    }

    public List<Community> getParentCommunityList() {
        return this.parentCommunityList;
    }

    public void addParentCommunityList(Community parentCommunity) {
        this.parentCommunityList.add(parentCommunity);
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getCopyrightText() {
        return this.copyrightText;
    }

    public void setCopyrightText(String copyrightText) {
        this.copyrightText = copyrightText;
    }

    public String getIntroductoryText() {
        return this.introductoryText;
    }

    public void setIntroductoryText(String introductoryText) {
        this.introductoryText = introductoryText;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getSidebarText() {
        return this.sidebarText;
    }

    public void setSidebarText(String sidebarText) {
        this.sidebarText = sidebarText;
    }
}

