/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest.common;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.ws.rs.WebApplicationException;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.rest.common.Community;
import org.dspace.rest.common.DSpaceObject;
import org.dspace.rest.common.Item;
import org.dspace.rest.common.ItemFilter;
import org.dspace.rest.filter.ItemFilterSet;

@XmlRootElement(name="filtered-collection")
public class FilteredCollection
extends DSpaceObject {
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    Logger log = Logger.getLogger(FilteredCollection.class);
    private Community parentCommunity;
    private Community topCommunity;
    private List<Community> parentCommunityList = new ArrayList();
    private List<Item> items = new ArrayList();
    private List<ItemFilter> itemFilters = new ArrayList();
    private Integer numberItems;
    private Integer numberItemsProcessed;

    public FilteredCollection() {
    }

    public FilteredCollection(Collection collection, ServletContext servletContext, String filters, String expand, Context context, Integer limit, Integer offset) throws SQLException, WebApplicationException {
        super((org.dspace.content.DSpaceObject)collection, servletContext);
        this.setup(collection, servletContext, expand, context, limit, offset, filters);
    }

    private void setup(Collection collection, ServletContext servletContext, String expand, Context context, Integer limit, Integer offset, String filters) throws SQLException {
        List parentCommunities;
        List<Object> expandFields = new ArrayList();
        if (expand != null) {
            expandFields = Arrays.asList(expand.split(","));
        }
        if (expandFields.contains("parentCommunityList") || expandFields.contains("all")) {
            parentCommunities = collection.getCommunities();
            ArrayList<Community> parentCommunityList = new ArrayList<Community>();
            for (org.dspace.content.Community parentCommunity : parentCommunities) {
                parentCommunityList.add(new Community(parentCommunity, servletContext, null, context));
            }
            this.setParentCommunityList(parentCommunityList);
        } else {
            this.addExpand("parentCommunityList");
        }
        if (expandFields.contains("parentCommunity") | expandFields.contains("all")) {
            org.dspace.content.Community parentCommunity = (org.dspace.content.Community)collection.getCommunities().get(0);
            this.setParentCommunity(new Community(parentCommunity, servletContext, null, context));
        } else {
            this.addExpand("parentCommunity");
        }
        if (expandFields.contains("topCommunity") | expandFields.contains("all")) {
            parentCommunities = collection.getCommunities();
            if (parentCommunities.size() > 0) {
                org.dspace.content.Community topCommunity = (org.dspace.content.Community)parentCommunities.get(parentCommunities.size() - 1);
                this.setTopCommunity(new Community(topCommunity, servletContext, null, context));
            }
        } else {
            this.addExpand("topCommunity");
        }
        boolean reportItems = expandFields.contains("items") || expandFields.contains("all");
        ItemFilterSet itemFilterSet = new ItemFilterSet(filters, reportItems);
        this.setItemFilters(itemFilterSet.getItemFilters());
        this.setNumberItemsProcessed(Integer.valueOf(0));
        if (this.itemFilters.size() > 0) {
            Iterator childItems = this.itemService.findByCollection(context, collection, limit, offset);
            int numProc = itemFilterSet.processSaveItems(context, servletContext, childItems, this.items, reportItems, expand);
            this.setNumberItemsProcessed(Integer.valueOf(numProc));
        }
        if (!expandFields.contains("all")) {
            this.addExpand("all");
        }
        this.setNumberItems(Integer.valueOf(this.itemService.countItems(context, collection)));
    }

    public Integer getNumberItems() {
        return this.numberItems;
    }

    public void setNumberItems(Integer numberItems) {
        this.numberItems = numberItems;
    }

    public Integer getNumberItemsProcessed() {
        return this.numberItemsProcessed;
    }

    public void setNumberItemsProcessed(Integer numberItemsProcessed) {
        this.numberItemsProcessed = numberItemsProcessed;
    }

    public Community getParentCommunity() {
        return this.parentCommunity;
    }

    public void setParentCommunity(Community parentCommunity) {
        this.parentCommunity = parentCommunity;
    }

    public Community getTopCommunity() {
        return this.topCommunity;
    }

    public void setTopCommunity(Community topCommunity) {
        this.topCommunity = topCommunity;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public void setParentCommunityList(List<Community> parentCommunityList) {
        this.parentCommunityList = parentCommunityList;
    }

    public List<Community> getParentCommunityList() {
        return this.parentCommunityList;
    }

    public List<ItemFilter> getItemFilters() {
        return this.itemFilters;
    }

    public void setItemFilters(List<ItemFilter> itemFilters) {
        this.itemFilters = itemFilters;
    }
}

