/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest;

import java.sql.SQLException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.rest.Resource;
import org.dspace.rest.common.Collection;
import org.dspace.rest.common.Community;
import org.dspace.rest.common.DSpaceObject;
import org.dspace.rest.common.Item;
import org.dspace.rest.exceptions.ContextException;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/handle")
public class HandleResource
extends Resource {
    protected HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    private static Logger log = Logger.getLogger(HandleResource.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{prefix}/{suffix}")
    @Produces(value={"application/json", "application/xml"})
    public DSpaceObject getObject(@PathParam(value="prefix") String prefix, @PathParam(value="suffix") String suffix, @QueryParam(value="expand") String expand, @Context HttpHeaders headers) {
        DSpaceObject dSpaceObject = new DSpaceObject();
        org.dspace.core.Context context = null;
        try {
            context = HandleResource.createContext();
            org.dspace.content.DSpaceObject dso = this.handleService.resolveToObject(context, prefix + "/" + suffix);
            if (dso == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            DSpaceObjectService dSpaceObjectService = ContentServiceFactory.getInstance().getDSpaceObjectService(dso);
            log.info((Object)("DSO Lookup by handle: [" + prefix + "] / [" + suffix + "] got result of: " + dSpaceObjectService.getTypeText(dso) + "_" + dso.getID()));
            if (this.authorizeService.authorizeActionBoolean(context, dso, 0)) {
                switch (dso.getType()) {
                    case 4: {
                        dSpaceObject = new Community((org.dspace.content.Community)dso, this.servletContext, expand, context);
                        break;
                    }
                    case 3: {
                        dSpaceObject = new Collection((org.dspace.content.Collection)dso, this.servletContext, expand, context, null, null);
                        break;
                    }
                    case 2: {
                        dSpaceObject = new Item((org.dspace.content.Item)dso, this.servletContext, expand, context);
                        break;
                    }
                    default: {
                        dSpaceObject = new DSpaceObject(dso, this.servletContext);
                        break;
                    }
                }
            } else {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            context.complete();
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (ContextException e) {
            HandleResource.processException((String)("Could not read handle(prefix=" + prefix + "), (suffix=" + suffix + ") ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        return dSpaceObject;
    }
}

