/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.dspace.rest.Resource;
import org.dspace.rest.common.Bitstream;
import org.dspace.rest.common.ResourcePolicy;
import org.dspace.rest.exceptions.ContextException;
import org.dspace.storage.bitstore.factory.StorageServiceFactory;
import org.dspace.storage.bitstore.service.BitstreamStorageService;
import org.dspace.usage.UsageEvent;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/bitstreams")
public class BitstreamResource
extends Resource {
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
    protected BitstreamStorageService bitstreamStorageService = StorageServiceFactory.getInstance().getBitstreamStorageService();
    protected ResourcePolicyService resourcePolicyService = AuthorizeServiceFactory.getInstance().getResourcePolicyService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    private static Logger log = Logger.getLogger(BitstreamResource.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{bitstream_id}")
    @Produces(value={"application/json", "application/xml"})
    public Bitstream getBitstream(@PathParam(value="bitstream_id") String bitstreamId, @QueryParam(value="expand") String expand, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Reading bitstream(id=" + bitstreamId + ") metadata."));
        org.dspace.core.Context context = null;
        Bitstream bitstream = null;
        try {
            context = BitstreamResource.createContext();
            org.dspace.content.Bitstream dspaceBitstream = this.findBitstream(context, bitstreamId, 0);
            this.writeStats((DSpaceObject)dspaceBitstream, UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
            bitstream = new Bitstream(dspaceBitstream, this.servletContext, expand, context);
            context.complete();
            log.trace((Object)("Bitstream(id=" + bitstreamId + ") was successfully read."));
        }
        catch (SQLException e) {
            BitstreamResource.processException((String)("Someting went wrong while reading bitstream(id=" + bitstreamId + ") from database! Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            BitstreamResource.processException((String)("Someting went wrong while reading bitstream(id=" + bitstreamId + "), ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        return bitstream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{bitstream_id}/policy")
    @Produces(value={"application/json", "application/xml"})
    public ResourcePolicy[] getBitstreamPolicies(@PathParam(value="bitstream_id") String bitstreamId, @Context HttpHeaders headers) {
        log.info((Object)("Reading bitstream(id=" + bitstreamId + ") policies."));
        org.dspace.core.Context context = null;
        ResourcePolicy[] policies = null;
        try {
            context = BitstreamResource.createContext();
            org.dspace.content.Bitstream dspaceBitstream = this.findBitstream(context, bitstreamId, 0);
            policies = new Bitstream(dspaceBitstream, this.servletContext, "policies", context).getPolicies();
            context.complete();
            log.trace((Object)("Policies for bitstream(id=" + bitstreamId + ") was successfully read."));
        }
        catch (SQLException e) {
            BitstreamResource.processException((String)("Someting went wrong while reading policies of bitstream(id=" + bitstreamId + "), SQLException! Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            BitstreamResource.processException((String)("Someting went wrong while reading policies of bitstream(id=" + bitstreamId + "), ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        return policies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json", "application/xml"})
    public Bitstream[] getBitstreams(@QueryParam(value="expand") String expand, @QueryParam(value="limit") @DefaultValue(value="100") Integer limit, @QueryParam(value="offset") @DefaultValue(value="0") Integer offset, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Reading bitstreams.(offset=" + offset + ",limit=" + limit + ")"));
        org.dspace.core.Context context = null;
        ArrayList<Bitstream> bitstreams = new ArrayList<Bitstream>();
        try {
            context = BitstreamResource.createContext();
            List dspaceBitstreams = this.bitstreamService.findAll(context);
            if (limit == null || limit < 0 || offset == null || offset < 0) {
                log.warn((Object)"Paging was badly set.");
                limit = 100;
                offset = 0;
            }
            for (int i = offset.intValue(); i < offset + limit && i < dspaceBitstreams.size(); ++i) {
                if (!this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)dspaceBitstreams.get(i), 0) || this.bitstreamService.getParentObject(context, (DSpaceObject)dspaceBitstreams.get(i)) == null) continue;
                bitstreams.add(new Bitstream((org.dspace.content.Bitstream)dspaceBitstreams.get(i), this.servletContext, expand, context));
                this.writeStats((DSpaceObject)dspaceBitstreams.get(i), UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
            }
            context.complete();
            log.trace((Object)"Bitstreams were successfully read.");
        }
        catch (SQLException e) {
            BitstreamResource.processException((String)("Something went wrong while reading bitstreams from database!. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            BitstreamResource.processException((String)("Something went wrong while reading bitstreams, ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        return bitstreams.toArray(new Bitstream[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{bitstream_id}/retrieve")
    public Response getBitstreamData(@PathParam(value="bitstream_id") String bitstreamId, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Reading data of bitstream(id=" + bitstreamId + ")."));
        org.dspace.core.Context context = null;
        InputStream inputStream = null;
        String type = null;
        String name = null;
        try {
            context = BitstreamResource.createContext();
            org.dspace.content.Bitstream dspaceBitstream = this.findBitstream(context, bitstreamId, 0);
            this.writeStats((DSpaceObject)dspaceBitstream, UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
            log.trace((Object)("Bitstream(id=" + bitstreamId + ") data was successfully read."));
            inputStream = this.bitstreamService.retrieve(context, dspaceBitstream);
            type = dspaceBitstream.getFormat(context).getMIMEType();
            name = dspaceBitstream.getName();
            context.complete();
        }
        catch (IOException e) {
            BitstreamResource.processException((String)("Could not read file of bitstream(id=" + bitstreamId + ")! Message: " + e), (org.dspace.core.Context)context);
        }
        catch (SQLException e) {
            BitstreamResource.processException((String)("Something went wrong while reading bitstream(id=" + bitstreamId + ") from database! Message: " + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            BitstreamResource.processException((String)("Could not retrieve file of bitstream(id=" + bitstreamId + "), AuthorizeException! Message: " + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            BitstreamResource.processException((String)("Could not retrieve file of bitstream(id=" + bitstreamId + "), ContextException! Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        return Response.ok(inputStream).type(type).header("Content-Disposition", (Object)("attachment; filename=\"" + name + "\"")).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{bitstream_id}/policy")
    @Consumes(value={"application/json", "application/xml"})
    public Response addBitstreamPolicy(@PathParam(value="bitstream_id") String bitstreamId, ResourcePolicy policy, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Adding bitstream(id=" + bitstreamId + ") " + policy.getAction() + " policy with permission for group(id=" + policy.getGroupId() + ")."));
        org.dspace.core.Context context = null;
        try {
            context = BitstreamResource.createContext();
            org.dspace.content.Bitstream dspaceBitstream = this.findBitstream(context, bitstreamId, 1);
            this.writeStats((DSpaceObject)dspaceBitstream, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            this.addPolicyToBitstream(context, policy, dspaceBitstream);
            context.complete();
            log.trace((Object)("Policy for bitstream(id=" + bitstreamId + ") was successfully added."));
        }
        catch (SQLException e) {
            BitstreamResource.processException((String)("Someting went wrong while adding policy to bitstream(id=" + bitstreamId + "), SQLException! Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            BitstreamResource.processException((String)("Someting went wrong while adding policy to bitstream(id=" + bitstreamId + "), ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            BitstreamResource.processException((String)("Someting went wrong while adding policy to bitstream(id=" + bitstreamId + "), AuthorizeException! Message: " + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/{bitstream_id}")
    @Consumes(value={"application/json", "application/xml"})
    public Response updateBitstream(@PathParam(value="bitstream_id") String bitstreamId, Bitstream bitstream, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Updating bitstream(id=" + bitstreamId + ") metadata."));
        org.dspace.core.Context context = null;
        try {
            context = BitstreamResource.createContext();
            org.dspace.content.Bitstream dspaceBitstream = this.findBitstream(context, bitstreamId, 1);
            this.writeStats((DSpaceObject)dspaceBitstream, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            log.trace((Object)"Updating bitstream metadata.");
            dspaceBitstream.setDescription(context, bitstream.getDescription());
            if (BitstreamResource.getMimeType((String)bitstream.getName()) == null) {
                BitstreamFormat unknownFormat = this.bitstreamFormatService.findUnknown(context);
                this.bitstreamService.setFormat(context, dspaceBitstream, unknownFormat);
            } else {
                BitstreamFormat guessedFormat = this.bitstreamFormatService.findByMIMEType(context, BitstreamResource.getMimeType((String)bitstream.getName()));
                this.bitstreamService.setFormat(context, dspaceBitstream, guessedFormat);
            }
            dspaceBitstream.setName(context, bitstream.getName());
            Integer sequenceId = bitstream.getSequenceId();
            if (sequenceId != null && sequenceId != -1) {
                dspaceBitstream.setSequenceID(sequenceId.intValue());
            }
            this.bitstreamService.update(context, (DSpaceObject)dspaceBitstream);
            if (bitstream.getPolicies() != null) {
                log.trace((Object)"Updating bitstream policies.");
                this.authorizeService.removeAllPolicies(context, (DSpaceObject)dspaceBitstream);
                for (ResourcePolicy policy : bitstream.getPolicies()) {
                    this.addPolicyToBitstream(context, policy, dspaceBitstream);
                }
            }
            context.complete();
        }
        catch (SQLException e) {
            BitstreamResource.processException((String)("Could not update bitstream(id=" + bitstreamId + ") metadata, SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            BitstreamResource.processException((String)("Could not update bitstream(id=" + bitstreamId + ") metadata, AuthorizeException. Message: " + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            BitstreamResource.processException((String)("Could not update bitstream(id=" + bitstreamId + ") metadata, ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info((Object)("Bitstream metadata(id=" + bitstreamId + ") were successfully updated."));
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/{bitstream_id}/data")
    public Response updateBitstreamData(@PathParam(value="bitstream_id") String bitstreamId, InputStream is, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Updating bitstream(id=" + bitstreamId + ") data."));
        org.dspace.core.Context context = null;
        try {
            context = BitstreamResource.createContext();
            org.dspace.content.Bitstream dspaceBitstream = this.findBitstream(context, bitstreamId, 1);
            this.writeStats((DSpaceObject)dspaceBitstream, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            log.trace((Object)"Creating new bitstream.");
            UUID newBitstreamId = this.bitstreamStorageService.store(context, dspaceBitstream, is);
            log.trace((Object)("Bitstream data stored: " + newBitstreamId));
        }
        catch (SQLException e) {
            BitstreamResource.processException((String)("Could not update bitstream(id=" + bitstreamId + ") data, SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (IOException e) {
            BitstreamResource.processException((String)("Could not update bitstream(id=" + bitstreamId + ") data, IOException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            BitstreamResource.processException((String)("Could not update bitstream(id=" + bitstreamId + ") data, ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info((Object)("Bitstream(id=" + bitstreamId + ") data was successfully updated."));
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{bitstream_id}")
    public Response deleteBitstream(@PathParam(value="bitstream_id") String bitstreamId, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Deleting bitstream(id=" + bitstreamId + ")."));
        org.dspace.core.Context context = null;
        try {
            context = BitstreamResource.createContext();
            org.dspace.content.Bitstream dspaceBitstream = this.findBitstream(context, bitstreamId, 2);
            this.writeStats((DSpaceObject)dspaceBitstream, UsageEvent.Action.DELETE, user_ip, user_agent, xforwardedfor, headers, request, context);
            log.trace((Object)"Deleting bitstream from all bundles.");
            this.bitstreamService.delete(context, (DSpaceObject)dspaceBitstream);
            context.complete();
        }
        catch (SQLException e) {
            BitstreamResource.processException((String)("Could not delete bitstream(id=" + bitstreamId + "), SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            BitstreamResource.processException((String)("Could not delete bitstream(id=" + bitstreamId + "), AuthorizeException. Message: " + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        catch (IOException e) {
            BitstreamResource.processException((String)("Could not delete bitstream(id=" + bitstreamId + "), IOException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            BitstreamResource.processException((String)("Could not delete bitstream(id=" + bitstreamId + "), ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info((Object)("Bitstream(id=" + bitstreamId + ") was successfully deleted."));
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{bitstream_id}/policy/{policy_id}")
    public Response deleteBitstreamPolicy(@PathParam(value="bitstream_id") String bitstreamId, @PathParam(value="policy_id") Integer policyId, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        block9: {
            log.info((Object)("Deleting  policy(id=" + policyId + ") from bitstream(id=" + bitstreamId + ")."));
            org.dspace.core.Context context = null;
            try {
                context = BitstreamResource.createContext();
                org.dspace.content.Bitstream dspaceBitstream = this.findBitstream(context, bitstreamId, 1);
                this.writeStats((DSpaceObject)dspaceBitstream, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwardedfor, headers, request, context);
                org.dspace.authorize.ResourcePolicy resourcePolicy = (org.dspace.authorize.ResourcePolicy)this.resourcePolicyService.find(context, policyId.intValue());
                if (!resourcePolicy.getdSpaceObject().getID().equals(dspaceBitstream.getID()) || !this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)dspaceBitstream, 4)) break block9;
                try {
                    this.resourcePolicyService.delete(context, (Object)resourcePolicy);
                }
                catch (AuthorizeException e) {
                    BitstreamResource.processException((String)("Someting went wrong while deleting policy(id=" + policyId + ") to bitstream(id=" + bitstreamId + "), AuthorizeException! Message: " + (Object)((Object)e)), (org.dspace.core.Context)context);
                }
                log.trace((Object)("Policy for bitstream(id=" + bitstreamId + ") was successfully removed."));
            }
            catch (SQLException e) {
                BitstreamResource.processException((String)("Someting went wrong while deleting policy(id=" + policyId + ") to bitstream(id=" + bitstreamId + "), SQLException! Message: " + e), (org.dspace.core.Context)context);
            }
            catch (ContextException e) {
                BitstreamResource.processException((String)("Someting went wrong while deleting policy(id=" + policyId + ") to bitstream(id=" + bitstreamId + "), ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
            }
            finally {
                this.processFinally(context);
            }
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    static String getMimeType(String name) {
        return URLConnection.guessContentTypeFromName(name);
    }

    private void addPolicyToBitstream(org.dspace.core.Context context, ResourcePolicy policy, org.dspace.content.Bitstream dspaceBitstream) throws SQLException, AuthorizeException {
        org.dspace.authorize.ResourcePolicy dspacePolicy = (org.dspace.authorize.ResourcePolicy)this.resourcePolicyService.create(context);
        dspacePolicy.setAction(policy.getActionInt());
        dspacePolicy.setGroup((Group)this.groupService.findByIdOrLegacyId(context, policy.getGroupId()));
        dspacePolicy.setdSpaceObject((DSpaceObject)dspaceBitstream);
        dspacePolicy.setStartDate(policy.getStartDate());
        dspacePolicy.setEndDate(policy.getEndDate());
        dspacePolicy.setRpDescription(policy.getRpDescription());
        dspacePolicy.setRpName(policy.getRpName());
        this.resourcePolicyService.update(context, (Object)dspacePolicy);
    }

    private org.dspace.content.Bitstream findBitstream(org.dspace.core.Context context, String id, int action) throws WebApplicationException {
        org.dspace.content.Bitstream bitstream = null;
        try {
            bitstream = (org.dspace.content.Bitstream)this.bitstreamService.findByIdOrLegacyId(context, id);
            if (bitstream == null || this.bitstreamService.getParentObject(context, (DSpaceObject)bitstream) == null) {
                context.abort();
                log.warn((Object)("Bitstream(id=" + id + ") was not found!"));
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            if (!this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)bitstream, action)) {
                context.abort();
                if (context.getCurrentUser() != null) {
                    log.error((Object)("User(" + context.getCurrentUser().getEmail() + ") doesn't have the permission to " + this.getActionString(action) + " bitstream!"));
                } else {
                    log.error((Object)("User(anonymous) doesn't have the permission to " + this.getActionString(action) + " bitsteam!"));
                }
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
        }
        catch (SQLException e) {
            BitstreamResource.processException((String)("Something went wrong while finding bitstream. SQLException, Message:" + e), (org.dspace.core.Context)context);
        }
        return bitstream;
    }
}

