/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.content.service.SiteService;
import org.dspace.rest.Resource;
import org.dspace.rest.common.MetadataField;
import org.dspace.rest.common.MetadataSchema;
import org.dspace.rest.exceptions.ContextException;
import org.dspace.usage.UsageEvent;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/registries")
public class MetadataRegistryResource
extends Resource {
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
    protected MetadataSchemaService metadataSchemaService = ContentServiceFactory.getInstance().getMetadataSchemaService();
    protected SiteService siteService = ContentServiceFactory.getInstance().getSiteService();
    private static Logger log = Logger.getLogger(MetadataRegistryResource.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/schema")
    @Produces(value={"application/json", "application/xml"})
    public MetadataSchema[] getSchemas(@QueryParam(value="expand") @DefaultValue(value="fields") String expand, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwarderfor") String xforwarderfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)"Reading all metadata schemas.");
        org.dspace.core.Context context = null;
        ArrayList<MetadataSchema> metadataSchemas = null;
        try {
            context = MetadataRegistryResource.createContext();
            List schemas = this.metadataSchemaService.findAll(context);
            metadataSchemas = new ArrayList<MetadataSchema>();
            for (org.dspace.content.MetadataSchema schema : schemas) {
                metadataSchemas.add(new MetadataSchema(schema, expand, context));
            }
            context.complete();
        }
        catch (SQLException e) {
            MetadataRegistryResource.processException((String)("Could not read metadata schemas, SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            MetadataRegistryResource.processException((String)("Could not read metadata schemas, ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.trace((Object)"All metadata schemas successfully read.");
        return metadataSchemas.toArray(new MetadataSchema[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/schema/{schema_prefix}")
    @Produces(value={"application/json", "application/xml"})
    public MetadataSchema getSchema(@PathParam(value="schema_prefix") String schemaPrefix, @QueryParam(value="expand") @DefaultValue(value="fields") String expand, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwarderfor") String xforwarderfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)"Reading metadata schemas.");
        org.dspace.core.Context context = null;
        MetadataSchema metadataSchema = null;
        try {
            context = MetadataRegistryResource.createContext();
            org.dspace.content.MetadataSchema schema = this.metadataSchemaService.find(context, schemaPrefix);
            metadataSchema = new MetadataSchema(schema, expand, context);
            if (schema == null) {
                MetadataRegistryResource.processException((String)String.format("Schema not found for index %s", schemaPrefix), (org.dspace.core.Context)context);
            }
            context.complete();
        }
        catch (SQLException e) {
            MetadataRegistryResource.processException((String)("Could not read metadata schema, SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            MetadataRegistryResource.processException((String)("Could not read metadata schema, ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.trace((Object)"Metadata schemas successfully read.");
        return metadataSchema;
    }

    @GET
    @Path(value="/schema/{schema_prefix}/metadata-fields/{element}")
    @Produces(value={"application/json", "application/xml"})
    public MetadataField getMetadataFieldUnqualified(@PathParam(value="schema_prefix") String schemaPrefix, @PathParam(value="element") String element, @QueryParam(value="expand") String expand, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwarderfor") String xforwarderfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        return this.getMetadataFieldQualified(schemaPrefix, element, "", expand, user_ip, user_agent, xforwarderfor, headers, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/schema/{schema_prefix}/metadata-fields/{element}/{qualifier}")
    @Produces(value={"application/json", "application/xml"})
    public MetadataField getMetadataFieldQualified(@PathParam(value="schema_prefix") String schemaPrefix, @PathParam(value="element") String element, @PathParam(value="qualifier") @DefaultValue(value="") String qualifier, @QueryParam(value="expand") String expand, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwarderfor") String xforwarderfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)"Reading metadata field.");
        org.dspace.core.Context context = null;
        MetadataField metadataField = null;
        try {
            context = MetadataRegistryResource.createContext();
            org.dspace.content.MetadataSchema schema = this.metadataSchemaService.find(context, schemaPrefix);
            if (schema == null) {
                log.error((Object)String.format("Schema not found for prefix %s", schemaPrefix));
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            org.dspace.content.MetadataField field = this.metadataFieldService.findByElement(context, schema, element, qualifier);
            if (field == null) {
                log.error((Object)String.format("Field %s.%s.%s not found", schemaPrefix, element, qualifier));
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            metadataField = new MetadataField(schema, field, expand, context);
            context.complete();
        }
        catch (SQLException e) {
            MetadataRegistryResource.processException((String)("Could not read metadata field, SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            MetadataRegistryResource.processException((String)("Could not read metadata field, ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.trace((Object)"Metadata field successfully read.");
        return metadataField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/metadata-fields/{field_id}")
    @Produces(value={"application/json", "application/xml"})
    public MetadataField getMetadataField(@PathParam(value="field_id") Integer fieldId, @QueryParam(value="expand") @DefaultValue(value="parentSchema") String expand, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwarderfor") String xforwarderfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)"Reading metadata field.");
        org.dspace.core.Context context = null;
        MetadataField metadataField = null;
        try {
            context = MetadataRegistryResource.createContext();
            org.dspace.content.MetadataField field = this.metadataFieldService.find(context, fieldId.intValue());
            if (field == null) {
                log.error((Object)String.format("Metadata Field %d not found", fieldId));
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            org.dspace.content.MetadataSchema schema = field.getMetadataSchema();
            if (schema == null) {
                log.error((Object)String.format("Parent Schema not found for Metadata Field %d not found", fieldId));
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            metadataField = new MetadataField(schema, field, expand, context);
            context.complete();
        }
        catch (SQLException e) {
            MetadataRegistryResource.processException((String)("Could not read metadata field, SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            MetadataRegistryResource.processException((String)("Could not read metadata field, ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.trace((Object)"Metadata field successfully read.");
        return metadataField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/schema")
    @Consumes(value={"application/json", "application/xml"})
    public MetadataSchema createSchema(MetadataSchema schema, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)"Creating a schema.");
        org.dspace.core.Context context = null;
        MetadataSchema retSchema = null;
        try {
            context = MetadataRegistryResource.createContext();
            if (!this.authorizeService.isAdmin(context)) {
                context.abort();
                String user = "anonymous";
                if (context.getCurrentUser() != null) {
                    user = context.getCurrentUser().getEmail();
                }
                log.error((Object)("User(" + user + ") does not have permission to create a metadata schema!"));
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            log.debug((Object)String.format("Admin user creating schema with namespace %s and prefix %s", schema.getNamespace(), schema.getPrefix()));
            org.dspace.content.MetadataSchema dspaceSchema = this.metadataSchemaService.create(context, schema.getPrefix(), schema.getNamespace());
            log.debug((Object)"Creating return object.");
            retSchema = new MetadataSchema(dspaceSchema, "", context);
            this.writeStats((DSpaceObject)this.siteService.findSite(context), UsageEvent.Action.CREATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            context.complete();
            log.info((Object)("Schema created" + retSchema.getPrefix()));
        }
        catch (SQLException e) {
            MetadataRegistryResource.processException((String)("Could not create new metadata schema, SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            MetadataRegistryResource.processException((String)("Could not create new metadata schema, ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            MetadataRegistryResource.processException((String)("Could not create new metadata schema, AuthorizeException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        catch (NonUniqueMetadataException e) {
            MetadataRegistryResource.processException((String)("Could not create new metadata schema, NonUniqueMetadataException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        catch (Exception e) {
            MetadataRegistryResource.processException((String)("Could not create new metadata schema, Exception. Class: " + e.getClass()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        return retSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/schema/{schema_prefix}/metadata-fields")
    @Consumes(value={"application/json", "application/xml"})
    public MetadataField createMetadataField(@PathParam(value="schema_prefix") String schemaPrefix, MetadataField field, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)String.format("Creating metadataField within schema %s.", schemaPrefix));
        org.dspace.core.Context context = null;
        MetadataField retField = null;
        try {
            context = MetadataRegistryResource.createContext();
            if (!this.authorizeService.isAdmin(context)) {
                context.abort();
                String user = "anonymous";
                if (context.getCurrentUser() != null) {
                    user = context.getCurrentUser().getEmail();
                }
                log.error((Object)("User(" + user + ") does not have permission to create a metadata field!"));
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            org.dspace.content.MetadataSchema schema = this.metadataSchemaService.find(context, schemaPrefix);
            if (schema == null) {
                log.error((Object)String.format("Schema not found for prefix %s", schemaPrefix));
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            org.dspace.content.MetadataField dspaceField = this.metadataFieldService.create(context, schema, field.getElement(), field.getQualifier(), field.getDescription());
            this.writeStats((DSpaceObject)this.siteService.findSite(context), UsageEvent.Action.CREATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            retField = new MetadataField(schema, dspaceField, "", context);
            context.complete();
            log.info((Object)("Metadata field created within schema" + retField.getName()));
        }
        catch (SQLException e) {
            MetadataRegistryResource.processException((String)("Could not create new metadata field, SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            MetadataRegistryResource.processException((String)("Could not create new metadata field, ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            MetadataRegistryResource.processException((String)("Could not create new metadata field, AuthorizeException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        catch (NonUniqueMetadataException e) {
            MetadataRegistryResource.processException((String)("Could not create new metadata field, NonUniqueMetadataException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        catch (Exception e) {
            MetadataRegistryResource.processException((String)("Could not create new metadata field, Exception. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        return retField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/metadata-fields/{field_id}")
    @Consumes(value={"application/json", "application/xml"})
    public Response updateMetadataField(@PathParam(value="field_id") Integer fieldId, MetadataField field, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Updating metadata field(id=" + fieldId + ")."));
        org.dspace.core.Context context = null;
        try {
            context = MetadataRegistryResource.createContext();
            org.dspace.content.MetadataField dspaceField = this.metadataFieldService.find(context, fieldId.intValue());
            if (field == null) {
                log.error((Object)String.format("Metadata Field %d not found", fieldId));
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            this.writeStats((DSpaceObject)this.siteService.findSite(context), UsageEvent.Action.UPDATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            dspaceField.setElement(field.getElement());
            dspaceField.setQualifier(field.getQualifier());
            dspaceField.setScopeNote(field.getDescription());
            this.metadataFieldService.update(context, dspaceField);
            context.complete();
        }
        catch (SQLException e) {
            MetadataRegistryResource.processException((String)("Could not update metadata field(id=" + fieldId + "), AuthorizeException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            MetadataRegistryResource.processException((String)("Could not update metadata field(id=" + fieldId + "), ContextException Message:" + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            MetadataRegistryResource.processException((String)("Could not update metadata field(id=" + fieldId + "), AuthorizeException. Message:" + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        catch (NonUniqueMetadataException e) {
            MetadataRegistryResource.processException((String)("Could not update metadata field(id=" + fieldId + "), NonUniqueMetadataException. Message:" + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        catch (IOException e) {
            MetadataRegistryResource.processException((String)("Could not update metadata field(id=" + fieldId + "), IOException. Message:" + e), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info((Object)("Metadata Field(id=" + fieldId + ") has been successfully updated."));
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/metadata-fields/{field_id}")
    public Response deleteMetadataField(@PathParam(value="field_id") Integer fieldId, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Deleting metadata field(id=" + fieldId + ")."));
        org.dspace.core.Context context = null;
        try {
            context = MetadataRegistryResource.createContext();
            org.dspace.content.MetadataField dspaceField = this.metadataFieldService.find(context, fieldId.intValue());
            if (dspaceField == null) {
                log.error((Object)String.format("Metadata Field %d not found", fieldId));
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            this.writeStats((DSpaceObject)this.siteService.findSite(context), UsageEvent.Action.DELETE, user_ip, user_agent, xforwardedfor, headers, request, context);
            this.metadataFieldService.delete(context, dspaceField);
            context.complete();
        }
        catch (SQLException e) {
            MetadataRegistryResource.processException((String)("Could not delete metadata field(id=" + fieldId + "), SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            MetadataRegistryResource.processException((String)("Could not delete metadata field(id=" + fieldId + "), AuthorizeException. Message:" + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            MetadataRegistryResource.processException((String)("Could not delete metadata field(id=" + fieldId + "), ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info((Object)("Metadata field(id=" + fieldId + ") was successfully deleted."));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/schema/{schema_id}")
    public Response deleteSchema(@PathParam(value="schema_id") Integer schemaId, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Deleting metadata schema(id=" + schemaId + ")."));
        org.dspace.core.Context context = null;
        try {
            context = MetadataRegistryResource.createContext();
            org.dspace.content.MetadataSchema dspaceSchema = this.metadataSchemaService.find(context, schemaId.intValue());
            if (dspaceSchema == null) {
                log.error((Object)String.format("Metadata Schema %d not found", schemaId));
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            this.writeStats((DSpaceObject)this.siteService.findSite(context), UsageEvent.Action.DELETE, user_ip, user_agent, xforwardedfor, headers, request, context);
            this.metadataSchemaService.delete(context, dspaceSchema);
            context.complete();
        }
        catch (SQLException e) {
            MetadataRegistryResource.processException((String)("Could not delete metadata schema(id=" + schemaId + "), SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            MetadataRegistryResource.processException((String)("Could not delete metadata schema(id=" + schemaId + "), AuthorizeException. Message:" + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            MetadataRegistryResource.processException((String)("Could not delete metadata schema(id=" + schemaId + "), ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info((Object)("Metadata schema(id=" + schemaId + ") was successfully deleted."));
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

