/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest.common;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.atteo.evo.inflector.English;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.DSpaceObjectService;

@XmlRootElement(name="dspaceobject")
public class DSpaceObject {
    private String uuid;
    private String name;
    private String handle;
    private String type;
    @XmlElement(name="link", required=true)
    private String link;
    @XmlElement(required=true)
    private ArrayList<String> expand = new ArrayList();

    public DSpaceObject() {
    }

    public DSpaceObject(org.dspace.content.DSpaceObject dso, ServletContext servletContext) {
        this.setUUID(dso.getID().toString());
        this.setName(dso.getName());
        this.setHandle(dso.getHandle());
        DSpaceObjectService dspaceObjectService = ContentServiceFactory.getInstance().getDSpaceObjectService(dso);
        this.setType(dspaceObjectService.getTypeText(dso).toLowerCase());
        this.link = this.createLink(servletContext);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public String getLink() {
        return this.link;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<String> getExpand() {
        return this.expand;
    }

    public void setExpand(ArrayList<String> expand) {
        this.expand = expand;
    }

    public void addExpand(String expandableAttribute) {
        this.expand.add(expandableAttribute);
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    private String createLink(ServletContext context) {
        return context.getContextPath() + "/" + English.plural((String)this.getType()) + "/" + this.getUUID();
    }
}

