/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest.filter;

import com.ibm.icu.util.Calendar;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.rest.filter.ItemFilterUtil;
import org.dspace.services.factory.DSpaceServicesFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ItemFilterUtil {
    protected static ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    static Logger log = Logger.getLogger(ItemFilterUtil.class);

    static String[] getDocumentMimeTypes() {
        return DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("rest.report-mime-document");
    }

    static String[] getSupportedDocumentMimeTypes() {
        return DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("rest.report-mime-document-supported");
    }

    static String[] getSupportedImageMimeTypes() {
        return DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("rest.report-mime-document-image");
    }

    static int countOriginalBitstream(Item item) {
        return ItemFilterUtil.countBitstream((BundleName)BundleName.ORIGINAL, (Item)item);
    }

    static int countBitstream(BundleName bundleName, Item item) {
        int count = 0;
        for (Bundle bundle : item.getBundles()) {
            if (!bundle.getName().equals(bundleName.name())) continue;
            count += bundle.getBitstreams().size();
        }
        return count;
    }

    static List<String> getBitstreamNames(BundleName bundleName, Item item) {
        ArrayList<String> names = new ArrayList<String>();
        for (Bundle bundle : item.getBundles()) {
            if (!bundle.getName().equals(bundleName.name())) continue;
            for (Bitstream bit : bundle.getBitstreams()) {
                names.add(bit.getName());
            }
        }
        return names;
    }

    static int countOriginalBitstreamMime(Context context, Item item, String[] mimeList) {
        return ItemFilterUtil.countBitstreamMime((Context)context, (BundleName)BundleName.ORIGINAL, (Item)item, (String[])mimeList);
    }

    static int countBitstreamMime(Context context, BundleName bundleName, Item item, String[] mimeList) {
        int count = 0;
        for (Bundle bundle : item.getBundles()) {
            if (!bundle.getName().equals(bundleName.name())) continue;
            for (Bitstream bit : bundle.getBitstreams()) {
                for (String mime : mimeList) {
                    try {
                        if (!bit.getFormat(context).getMIMEType().equals(mime.trim())) continue;
                        ++count;
                    }
                    catch (SQLException e) {
                        log.error((Object)("Get format error for bitstream " + bit.getName()));
                    }
                }
            }
        }
        return count;
    }

    static int countBitstreamByDesc(BundleName bundleName, Item item, String[] descList) {
        int count = 0;
        for (Bundle bundle : item.getBundles()) {
            if (!bundle.getName().equals(bundleName.name())) continue;
            for (Bitstream bit : bundle.getBitstreams()) {
                for (String desc : descList) {
                    String bitDesc = bit.getDescription();
                    if (bitDesc == null || !bitDesc.equals(desc.trim())) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    static int countBitstreamSmallerThanMinSize(Context context, BundleName bundleName, Item item, String[] mimeList, String prop) {
        long size = DSpaceServicesFactory.getInstance().getConfigurationService().getLongProperty(prop);
        int count = 0;
        try {
            for (Bundle bundle : item.getBundles()) {
                if (!bundle.getName().equals(bundleName.name())) continue;
                for (Bitstream bit : bundle.getBitstreams()) {
                    for (String mime : mimeList) {
                        if (!bit.getFormat(context).getMIMEType().equals(mime.trim()) || bit.getSize() >= size) continue;
                        ++count;
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return count;
    }

    static int countBitstreamLargerThanMaxSize(Context context, BundleName bundleName, Item item, String[] mimeList, String prop) {
        long size = DSpaceServicesFactory.getInstance().getConfigurationService().getLongProperty(prop);
        int count = 0;
        try {
            for (Bundle bundle : item.getBundles()) {
                if (!bundle.getName().equals(bundleName.name())) continue;
                for (Bitstream bit : bundle.getBitstreams()) {
                    for (String mime : mimeList) {
                        if (!bit.getFormat(context).getMIMEType().equals(mime.trim()) || bit.getSize() <= size) continue;
                        ++count;
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return count;
    }

    static int countOriginalBitstreamMimeStartsWith(Context context, Item item, String prefix) {
        return ItemFilterUtil.countBitstreamMimeStartsWith((Context)context, (BundleName)BundleName.ORIGINAL, (Item)item, (String)prefix);
    }

    static int countBitstreamMimeStartsWith(Context context, BundleName bundleName, Item item, String prefix) {
        int count = 0;
        try {
            for (Bundle bundle : item.getBundles()) {
                if (!bundle.getName().equals(bundleName.name())) continue;
                for (Bitstream bit : bundle.getBitstreams()) {
                    if (!bit.getFormat(context).getMIMEType().startsWith(prefix)) continue;
                    ++count;
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return count;
    }

    static boolean hasUnsupportedBundle(Item item, String[] bundleList) {
        if (bundleList == null) {
            return false;
        }
        ArrayList<String> bundles = new ArrayList<String>();
        for (String bundleName : bundleList) {
            bundles.add(bundleName.trim());
        }
        for (Bundle bundle : item.getBundles()) {
            if (bundles.contains(bundle.getName())) continue;
            return true;
        }
        return false;
    }

    static boolean hasOriginalBitstreamMime(Context context, Item item, String[] mimeList) {
        return ItemFilterUtil.hasBitstreamMime((Context)context, (BundleName)BundleName.ORIGINAL, (Item)item, (String[])mimeList);
    }

    static boolean hasBitstreamMime(Context context, BundleName bundleName, Item item, String[] mimeList) {
        return ItemFilterUtil.countBitstreamMime((Context)context, (BundleName)bundleName, (Item)item, (String[])mimeList) > 0;
    }

    static boolean hasMetadataMatch(Item item, String fieldList, Pattern regex) {
        if (fieldList.equals("*")) {
            for (MetadataValue md : itemService.getMetadata((DSpaceObject)item, "*", "*", "*", "*")) {
                if (!regex.matcher(md.getValue()).matches()) continue;
                return true;
            }
        } else {
            for (String field : fieldList.split(",")) {
                for (MetadataValue md : itemService.getMetadataByMetadataString((DSpaceObject)item, field.trim())) {
                    if (!regex.matcher(md.getValue()).matches()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static boolean hasOnlyMetadataMatch(Item item, String fieldList, Pattern regex) {
        boolean matches = false;
        if (fieldList.equals("*")) {
            for (MetadataValue md : itemService.getMetadata((DSpaceObject)item, "*", "*", "*", "*")) {
                if (regex.matcher(md.getValue()).matches()) {
                    matches = true;
                    continue;
                }
                return false;
            }
        } else {
            for (String field : fieldList.split(",")) {
                for (MetadataValue md : itemService.getMetadataByMetadataString((DSpaceObject)item, field.trim())) {
                    if (regex.matcher(md.getValue()).matches()) {
                        matches = true;
                        continue;
                    }
                    return false;
                }
            }
        }
        return matches;
    }

    static boolean recentlyModified(Item item, int days) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -days);
        return cal.getTime().before(item.getLastModified());
    }
}

