/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.authenticate.ShibAuthentication;
import org.dspace.authenticate.factory.AuthenticateServiceFactory;
import org.dspace.authenticate.service.AuthenticationService;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.rest.Resource;
import org.dspace.rest.common.Status;
import org.dspace.rest.exceptions.ContextException;
import org.dspace.services.model.Request;
import org.dspace.utils.DSpace;

@Path(value="/")
public class RestIndex {
    protected EPersonService epersonService = EPersonServiceFactory.getInstance().getEPersonService();
    private static Logger log = LogManager.getLogger(RestIndex.class);

    @GET
    @Produces(value={"text/html"})
    public String sayHtmlHello(@Context ServletContext servletContext) {
        return "<html><title>DSpace REST - index</title><body><h1>DSpace REST API (Deprecated)</h1><em>This REST API is deprecated and will be removed in v8. Please use the new Server API webapp instead.</em><br/>Server path: " + servletContext.getContextPath() + "<h2>Index</h2><ul><li>GET / - Return this page.</li><li>GET /test - Return the string \"REST api is running\" for testing purposes.</li><li>POST /login - Method for logging into the DSpace RESTful API. You must post the parameters \"email\" and \"password\". Example: \"email=test@dspace&password=pass\". Returns a JSESSIONID cookie which can be used for future authenticated requests.</li><li>POST /logout - Method for logging out of the DSpace RESTful API. The request must include the \"rest-dspace-token\" token</li> header.</ul><h2>Communities</h2><ul><li>GET /communities - Return an array of all communities in DSpace.</li><li>GET /communities/top-communities - Returns an array of all top-leve communities in DSpace.</li><li>GET /communities/{communityId} - Returns a community with the specified ID.</li><li>GET /communities/{communityId}/collections - Returns an array of collections of the specified community.</li><li>GET /communities/{communityId}/communities - Returns an array of subcommunities of the specified community.</li><li>POST /communities - Create a new top-level community. You must post a community.</li><li>POST /communities/{communityId}/collections - Create a new collection in the specified community. You must post a collection.</li><li>POST /communities/{communityId}/communities - Create a new subcommunity in the specified community. You must post a community.</li><li>PUT /communities/{communityId} - Update the specified community.</li><li>DELETE /communities/{communityId} - Delete the specified community.</li><li>DELETE /communities/{communityId}/collections/{collectionId} - Delete the specified collection in the specified community.</li><li>DELETE /communities/{communityId}/communities/{communityId2} - Delete the specified subcommunity (communityId2) in the specified community (communityId).</li></ul><h2>Collections</h2><ul><li>GET /collections - Return all DSpace collections in array.</li><li>GET /collections/{collectionId} - Return a collection with the specified ID.</li><li>GET /collections/{collectionId}/items - Return all items of the specified collection.</li><li>POST /collections/{collectionId}/items - Create an item in the specified collection. You must post an item.</li><li>POST /collections/find-collection - Find a collection by name.</li><li>PUT /collections/{collectionId} </li> - Update the specified collection. You must post a collection.<li>DELETE /collections/{collectionId} - Delete the specified collection from DSpace.</li><li>DELETE /collections/{collectionId}/items/{itemId} - Delete the specified item (itemId) in the specified collection (collectionId). </li></ul><h2>Items</h2><ul><li>GET /items - Return a list of items.</li><li>GET /items/{item id} - Return the specified item.</li><li>GET /items/{item id}/metadata - Return metadata of the specified item.</li><li>GET /items/{item id}/bitstreams - Return bitstreams of the specified item.</li><li>POST /items/find-by-metadata-field - Find items by the specified metadata value.</li><li>POST /items/{item id}/metadata - Add metadata to the specified item.</li><li>POST /items/{item id}/bitstreams - Add a bitstream to the specified item.</li><li>PUT /items/{item id}/metadata - Update metadata in the specified item.</li><li>DELETE /items/{item id} - Delete the specified item.</li><li>DELETE /items/{item id}/metadata - Clear metadata of the specified item.</li><li>DELETE /items/{item id}/bitstreams/{bitstream id} - Delete the specified bitstream of the specified item.</li></ul><h2>Bitstreams</h2><ul><li>GET /bitstreams - Return all bitstreams in DSpace.</li><li>GET /bitstreams/{bitstream id} - Return the specified bitstream.</li><li>GET /bitstreams/{bitstream id}/policy - Return policies of the specified bitstream.</li><li>GET /bitstreams/{bitstream id}/retrieve - Return the contents of the specified bitstream.</li><li>POST /bitstreams/{bitstream id}/policy - Add a policy to the specified bitstream.</li><li>PUT /bitstreams/{bitstream id}/data - Update the contents of the specified bitstream.</li><li>PUT /bitstreams/{bitstream id} - Update metadata of the specified bitstream.</li><li>DELETE /bitstreams/{bitstream id} - Delete the specified bitstream from DSpace.</li><li>DELETE /bitstreams/{bitstream id}/policy/{policy_id} - Delete the specified bitstream policy.</li></ul><h2>Hierarchy</h2><ul><li>GET /hierarchy - Return hierarchy of communities and collections in tree form. Each object is minimally populated (name, handle, id) for efficient retrieval.</li></ul><h2>Metadata and Schema Registry</h2><ul><li>GET /registries/schema - Return the list of metadata schemas in the registry</li><li>GET /registries/schema/{schema_prefix} - Returns the specified metadata schema</li><li>GET /registries/schema/{schema_prefix}/metadata-fields/{element} - Returns the metadata field within a schema with an unqualified element name</li><li>GET /registries/schema/{schema_prefix}/metadata-fields/{element}/{qualifier} - Returns the metadata field within a schema with a qualified element name</li><li>POST /registries/schema/ - Add a schema to the schema registry</li><li>POST /registries/schema/{schema_prefix}/metadata-fields - Add a metadata field to the specified schema</li><li>GET /registries/metadata-fields/{field_id} - Return the specified metadata field</li><li>PUT /registries/metadata-fields/{field_id} - Update the specified metadata field</li><li>DELETE /registries/metadata-fields/{field_id} - Delete the specified metadata field from the metadata field registry</li><li>DELETE /registries/schema/{schema_id} - Delete the specified schema from the schema registry</li></ul><h2>Query/Reporting Tools</h2><ul><li>GET /reports - Return a list of report tools built on the rest api</li><li>GET /reports/{nickname} - Return a redirect to a specific report</li><li>GET /filters - Return a list of use case filters available for quality control reporting</li><li>GET /filtered-collections - Return collections and item counts based on pre-defined filters</li><li>GET /filtered-collections/{collection_id} - Return items and item counts for a collection based on pre-defined filters</li><li>GET /filtered-items - Retrieve a set of items based on a metadata query and a set of filters</li></ul></body></html> ";
    }

    @GET
    @Path(value="/test")
    public String test() {
        return "REST api is running.";
    }

    @POST
    @Path(value="/login")
    @Consumes(value={"application/json", "application/xml"})
    public Response login() {
        return Response.ok().build();
    }

    @GET
    @Path(value="/shibboleth-login")
    @Consumes(value={"application/json", "application/xml"})
    public Response shibbolethLogin() {
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/login-shibboleth")
    @Consumes(value={"application/json", "application/xml"})
    public Response shibbolethLoginEndPoint() {
        org.dspace.core.Context context = null;
        try {
            context = Resource.createContext();
            AuthenticationService authenticationService = AuthenticateServiceFactory.getInstance().getAuthenticationService();
            Iterator authenticationMethodIterator = authenticationService.authenticationMethodIterator();
            while (authenticationMethodIterator.hasNext()) {
                Request currentRequest;
                String loginPageURL;
                AuthenticationMethod authenticationMethod = (AuthenticationMethod)authenticationMethodIterator.next();
                if (!(authenticationMethod instanceof ShibAuthentication) || !StringUtils.isNotBlank((CharSequence)(loginPageURL = authenticationMethod.loginPageURL(context, (currentRequest = new DSpace().getRequestService().getCurrentRequest()).getHttpServletRequest(), currentRequest.getHttpServletResponse())))) continue;
                currentRequest.getHttpServletResponse().sendRedirect(loginPageURL);
            }
            context.abort();
        }
        catch (IOException | SQLException | ContextException e) {
            Resource.processException((String)("Shibboleth endpoint error:  " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            if (context != null && context.isValid()) {
                context.abort();
            }
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="/logout")
    @Consumes(value={"application/json", "application/xml"})
    public Response logout(@Context HttpHeaders headers) {
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/status")
    @Consumes(value={"application/json", "application/xml"})
    public Status status(@Context HttpHeaders headers) throws UnsupportedEncodingException {
        org.dspace.core.Context context = null;
        try {
            context = Resource.createContext();
            EPerson ePerson = context.getCurrentUser();
            if (ePerson != null) {
                Status status;
                EPerson dbEPerson = this.epersonService.findByEmail(context, ePerson.getEmail());
                Status status2 = status = new Status(dbEPerson.getEmail(), dbEPerson.getFullName());
                return status2;
            }
        }
        catch (ContextException e) {
            Resource.processException((String)("Status context error: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        catch (SQLException e) {
            Resource.processException((String)("Status eperson db lookup error: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            context.abort();
        }
        return new Status();
    }
}

