/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.dspace.rest.BitstreamResource;
import org.dspace.rest.Resource;
import org.dspace.rest.common.Bitstream;
import org.dspace.rest.common.Item;
import org.dspace.rest.common.MetadataEntry;
import org.dspace.rest.exceptions.ContextException;
import org.dspace.usage.UsageEvent;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/items")
public class ItemsResource
extends Resource {
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
    protected BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected ResourcePolicyService resourcePolicyService = AuthorizeServiceFactory.getInstance().getResourcePolicyService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    private static final Logger log = LogManager.getLogger(ItemsResource.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{item_id}")
    @Produces(value={"application/json", "application/xml"})
    public Item getItem(@PathParam(value="item_id") String itemId, @QueryParam(value="expand") String expand, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info("Reading item(id=" + itemId + ").");
        org.dspace.core.Context context = null;
        Item item = null;
        try {
            context = ItemsResource.createContext();
            org.dspace.content.Item dspaceItem = this.findItem(context, itemId, 0);
            this.writeStats((DSpaceObject)dspaceItem, UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
            item = new Item(dspaceItem, this.servletContext, expand, context);
            context.complete();
            log.trace("Item(id=" + itemId + ") was successfully read.");
        }
        catch (SQLException e) {
            ItemsResource.processException((String)("Could not read item(id=" + itemId + "), SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            ItemsResource.processException((String)("Could not read item(id=" + itemId + "), ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json", "application/xml"})
    public Item[] getItems(@QueryParam(value="expand") String expand, @QueryParam(value="limit") @DefaultValue(value="100") Integer limit, @QueryParam(value="offset") @DefaultValue(value="0") Integer offset, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info("Reading items.(offset=" + offset + ",limit=" + limit + ").");
        org.dspace.core.Context context = null;
        ArrayList<Item> items = null;
        try {
            context = ItemsResource.createContext();
            Iterator dspaceItems = this.itemService.findAllUnfiltered(context);
            items = new ArrayList<Item>();
            if (limit == null || limit < 0 || offset == null || offset < 0) {
                log.warn("Paging was badly set, using default values.");
                limit = 100;
                offset = 0;
            }
            for (int i = 0; dspaceItems.hasNext() && i < limit + offset; ++i) {
                org.dspace.content.Item dspaceItem = (org.dspace.content.Item)dspaceItems.next();
                if (i < offset || !this.itemService.isItemListedForUser(context, dspaceItem)) continue;
                items.add(new Item(dspaceItem, this.servletContext, expand, context));
                this.writeStats((DSpaceObject)dspaceItem, UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
            }
            context.complete();
        }
        catch (SQLException e) {
            ItemsResource.processException((String)("Something went wrong while reading items from database. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            ItemsResource.processException((String)("Something went wrong while reading items, ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.trace("Items were successfully read.");
        return items.toArray(new Item[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{item_id}/metadata")
    @Produces(value={"application/json", "application/xml"})
    public MetadataEntry[] getItemMetadata(@PathParam(value="item_id") String itemId, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info("Reading item(id=" + itemId + ") metadata.");
        org.dspace.core.Context context = null;
        List metadata = null;
        try {
            context = ItemsResource.createContext();
            org.dspace.content.Item dspaceItem = this.findItem(context, itemId, 0);
            this.writeStats((DSpaceObject)dspaceItem, UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
            metadata = new Item(dspaceItem, this.servletContext, "metadata", context).getMetadata();
            context.complete();
        }
        catch (SQLException e) {
            ItemsResource.processException((String)("Could not read item(id=" + itemId + "), SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            ItemsResource.processException((String)("Could not read item(id=" + itemId + "), ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.trace("Item(id=" + itemId + ") metadata were successfully read.");
        return metadata.toArray(new MetadataEntry[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{item_id}/bitstreams")
    @Produces(value={"application/json", "application/xml"})
    public Bitstream[] getItemBitstreams(@PathParam(value="item_id") String itemId, @QueryParam(value="limit") @DefaultValue(value="20") Integer limit, @QueryParam(value="offset") @DefaultValue(value="0") Integer offset, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info("Reading item(id=" + itemId + ") bitstreams.(offset=" + offset + ",limit=" + limit + ")");
        org.dspace.core.Context context = null;
        List bitstreams = null;
        try {
            context = ItemsResource.createContext();
            org.dspace.content.Item dspaceItem = this.findItem(context, itemId, 0);
            this.writeStats((DSpaceObject)dspaceItem, UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
            List itemBitstreams = new Item(dspaceItem, this.servletContext, "bitstreams", context).getBitstreams();
            bitstreams = offset + limit > itemBitstreams.size() - offset ? itemBitstreams.subList(offset, itemBitstreams.size()) : itemBitstreams.subList(offset, offset + limit);
            context.complete();
        }
        catch (SQLException e) {
            ItemsResource.processException((String)("Could not read item(id=" + itemId + ") bitstreams, SQLExcpetion. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            ItemsResource.processException((String)("Could not read item(id=" + itemId + ") bitstreams, ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.trace("Item(id=" + itemId + ") bitstreams were successfully read.");
        return bitstreams.toArray(new Bitstream[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{item_id}/metadata")
    @Consumes(value={"application/json", "application/xml"})
    public Response addItemMetadata(@PathParam(value="item_id") String itemId, List<MetadataEntry> metadata, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info("Adding metadata to item(id=" + itemId + ").");
        org.dspace.core.Context context = null;
        try {
            context = ItemsResource.createContext();
            org.dspace.content.Item dspaceItem = this.findItem(context, itemId, 1);
            this.writeStats((DSpaceObject)dspaceItem, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            for (MetadataEntry entry : metadata) {
                String[] data = this.mySplit(entry.getKey());
                if (data.length < 2 || data.length > 3) continue;
                this.itemService.addMetadata(context, (DSpaceObject)dspaceItem, data[0], data[1], data[2], entry.getLanguage(), entry.getValue());
            }
            context.complete();
        }
        catch (SQLException e) {
            ItemsResource.processException((String)("Could not write metadata to item(id=" + itemId + "), SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            ItemsResource.processException((String)("Could not write metadata to item(id=" + itemId + "), ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info("Metadata to item(id=" + itemId + ") were successfully added.");
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{item_id}/bitstreams")
    public Bitstream addItemBitstream(@PathParam(value="item_id") String itemId, InputStream inputStream, @QueryParam(value="name") String name, @QueryParam(value="description") String description, @QueryParam(value="groupId") String groupId, @QueryParam(value="year") Integer year, @QueryParam(value="month") Integer month, @QueryParam(value="day") Integer day, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info("Adding bitstream to item(id=" + itemId + ").");
        org.dspace.core.Context context = null;
        Bitstream bitstream = null;
        try {
            context = ItemsResource.createContext();
            org.dspace.content.Item dspaceItem = this.findItem(context, itemId, 1);
            this.writeStats((DSpaceObject)dspaceItem, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            log.trace("Creating bitstream in item.");
            Bundle bundle = null;
            org.dspace.content.Bitstream dspaceBitstream = null;
            List bundles = this.itemService.getBundles(dspaceItem, "ORIGINAL");
            if (bundles != null && bundles.size() != 0) {
                bundle = (Bundle)bundles.get(0);
            }
            if (bundle == null) {
                log.trace("Creating bundle in item.");
                dspaceBitstream = this.itemService.createSingleBitstream(context, inputStream, dspaceItem);
            } else {
                log.trace("Getting bundle from item.");
                dspaceBitstream = this.bitstreamService.create(context, bundle, inputStream);
            }
            dspaceBitstream.setSource(context, "DSpace REST API");
            if (name != null) {
                if (BitstreamResource.getMimeType((String)name) == null) {
                    dspaceBitstream.setFormat(context, this.bitstreamFormatService.findUnknown(context));
                } else {
                    this.bitstreamService.setFormat(context, dspaceBitstream, this.bitstreamFormatService.findByMIMEType(context, BitstreamResource.getMimeType((String)name)));
                }
                dspaceBitstream.setName(context, name);
            }
            if (description != null) {
                dspaceBitstream.setDescription(context, description);
            }
            if (groupId != null) {
                bundles = dspaceBitstream.getBundles();
                for (Bundle dspaceBundle : bundles) {
                    List bitstreamsPolicies = this.bundleService.getBitstreamPolicies(context, dspaceBundle);
                    ArrayList<ResourcePolicy> policiesToRemove = new ArrayList<ResourcePolicy>();
                    for (ResourcePolicy policy : bitstreamsPolicies) {
                        if (!policy.getdSpaceObject().getID().equals(dspaceBitstream.getID())) continue;
                        policiesToRemove.add(policy);
                    }
                    for (ResourcePolicy policy : policiesToRemove) {
                        bitstreamsPolicies.remove(policy);
                    }
                    ResourcePolicy dspacePolicy = (ResourcePolicy)this.resourcePolicyService.create(context);
                    dspacePolicy.setAction(0);
                    dspacePolicy.setGroup((Group)this.groupService.findByIdOrLegacyId(context, groupId));
                    dspacePolicy.setdSpaceObject((DSpaceObject)dspaceBitstream);
                    if (year != null || month != null || day != null) {
                        Date date = new Date();
                        if (year != null) {
                            date.setYear(year - 1900);
                        }
                        if (month != null) {
                            date.setMonth(month - 1);
                        }
                        if (day != null) {
                            date.setDate(day);
                        }
                        date.setHours(0);
                        date.setMinutes(0);
                        date.setSeconds(0);
                        dspacePolicy.setStartDate(date);
                    }
                    this.resourcePolicyService.update(context, (Object)dspacePolicy);
                    this.bitstreamService.updateLastModified(context, (DSpaceObject)dspaceBitstream);
                }
            }
            dspaceBitstream = this.bitstreamService.find(context, dspaceBitstream.getID());
            bitstream = new Bitstream(dspaceBitstream, this.servletContext, "", context);
            context.complete();
        }
        catch (SQLException e) {
            ItemsResource.processException((String)("Could not create bitstream in item(id=" + itemId + "), SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            ItemsResource.processException((String)("Could not create bitstream in item(id=" + itemId + "), AuthorizeException. Message: " + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        catch (IOException e) {
            ItemsResource.processException((String)("Could not create bitstream in item(id=" + itemId + "), IOException Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            ItemsResource.processException((String)("Could not create bitstream in item(id=" + itemId + "), ContextException Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info("Bitstream(id=" + bitstream.getUUID() + ") was successfully added into item(id=" + itemId + ").");
        return bitstream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/{item_id}/metadata")
    @Consumes(value={"application/json", "application/xml"})
    public Response updateItemMetadata(@PathParam(value="item_id") String itemId, MetadataEntry[] metadata, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info("Updating metadata in item(id=" + itemId + ").");
        org.dspace.core.Context context = null;
        try {
            String[] data;
            context = ItemsResource.createContext();
            org.dspace.content.Item dspaceItem = this.findItem(context, itemId, 1);
            this.writeStats((DSpaceObject)dspaceItem, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            log.trace("Deleting original metadata from item.");
            for (MetadataEntry entry : metadata) {
                data = this.mySplit(entry.getKey());
                if (data.length < 2 || data.length > 3) continue;
                this.itemService.clearMetadata(context, (DSpaceObject)dspaceItem, data[0], data[1], data[2], "*");
            }
            log.trace("Adding new metadata to item.");
            for (MetadataEntry entry : metadata) {
                data = this.mySplit(entry.getKey());
                if (data.length < 2 || data.length > 3) continue;
                this.itemService.addMetadata(context, (DSpaceObject)dspaceItem, data[0], data[1], data[2], entry.getLanguage(), entry.getValue());
            }
            this.itemService.update(context, (DSpaceObject)dspaceItem);
            context.complete();
        }
        catch (SQLException e) {
            ItemsResource.processException((String)("Could not update metadata in item(id=" + itemId + "), SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            ItemsResource.processException((String)("Could not update metadata in item(id=" + itemId + "), ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            ItemsResource.processException((String)("Could not update metadata in item(id=" + itemId + "), AuthorizeException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info("Metadata of item(id=" + itemId + ") were successfully updated.");
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{item_id}")
    public Response deleteItem(@PathParam(value="item_id") String itemId, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info("Deleting item(id=" + itemId + ").");
        org.dspace.core.Context context = null;
        try {
            context = ItemsResource.createContext();
            org.dspace.content.Item dspaceItem = this.findItem(context, itemId, 2);
            this.writeStats((DSpaceObject)dspaceItem, UsageEvent.Action.REMOVE, user_ip, user_agent, xforwardedfor, headers, request, context);
            log.trace("Deleting item.");
            this.itemService.delete(context, (DSpaceObject)dspaceItem);
            context.complete();
        }
        catch (SQLException e) {
            ItemsResource.processException((String)("Could not delete item(id=" + itemId + "), SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            ItemsResource.processException((String)("Could not delete item(id=" + itemId + "), AuthorizeException. Message: " + (Object)((Object)e)), (org.dspace.core.Context)context);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (IOException e) {
            ItemsResource.processException((String)("Could not delete item(id=" + itemId + "), IOException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            ItemsResource.processException((String)("Could not delete item(id=" + itemId + "), ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info("Item(id=" + itemId + ") was successfully deleted.");
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{item_id}/metadata")
    public Response deleteItemMetadata(@PathParam(value="item_id") String itemId, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info("Deleting metadata in item(id=" + itemId + ").");
        org.dspace.core.Context context = null;
        try {
            context = ItemsResource.createContext();
            org.dspace.content.Item dspaceItem = this.findItem(context, itemId, 1);
            this.writeStats((DSpaceObject)dspaceItem, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            log.trace("Deleting metadata.");
            String valueAccessioned = this.itemService.getMetadataFirstValue((DSpaceObject)dspaceItem, "dc", "date", "accessioned", "*");
            String valueAvailable = this.itemService.getMetadataFirstValue((DSpaceObject)dspaceItem, "dc", "date", "available", "*");
            String valueURI = this.itemService.getMetadataFirstValue((DSpaceObject)dspaceItem, "dc", "identifier", "uri", "*");
            String valueProvenance = this.itemService.getMetadataFirstValue((DSpaceObject)dspaceItem, "dc", "description", "provenance", "*");
            this.itemService.clearMetadata(context, (DSpaceObject)dspaceItem, "*", "*", "*", "*");
            this.itemService.addMetadata(context, (DSpaceObject)dspaceItem, "dc", "date", "accessioned", null, valueAccessioned);
            this.itemService.addMetadata(context, (DSpaceObject)dspaceItem, "dc", "date", "available", null, valueAvailable);
            this.itemService.addMetadata(context, (DSpaceObject)dspaceItem, "dc", "identifier", "uri", null, valueURI);
            this.itemService.addMetadata(context, (DSpaceObject)dspaceItem, "dc", "description", "provenance", null, valueProvenance);
            context.complete();
        }
        catch (SQLException e) {
            ItemsResource.processException((String)("Could not delete item(id=" + itemId + "), SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            ItemsResource.processException((String)("Could not delete item(id=" + itemId + "), ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info("Item(id=" + itemId + ") metadata were successfully deleted.");
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{item_id}/bitstreams/{bitstream_id}")
    public Response deleteItemBitstream(@PathParam(value="item_id") String itemId, @PathParam(value="bitstream_id") String bitstreamId, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info("Deleting bitstream in item(id=" + itemId + ").");
        org.dspace.core.Context context = null;
        try {
            context = ItemsResource.createContext();
            org.dspace.content.Item item = this.findItem(context, itemId, 1);
            org.dspace.content.Bitstream bitstream = (org.dspace.content.Bitstream)this.bitstreamService.findByIdOrLegacyId(context, bitstreamId);
            if (bitstream == null) {
                context.abort();
                log.warn("Bitstream(id=" + bitstreamId + ") was not found.");
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                return response;
            }
            if (!this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)bitstream, 2)) {
                context.abort();
                log.error("User(" + context.getCurrentUser().getEmail() + ") is not allowed to delete bitstream(id=" + bitstreamId + ").");
                Response response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                return response;
            }
            this.writeStats((DSpaceObject)item, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            this.writeStats((DSpaceObject)bitstream, UsageEvent.Action.REMOVE, user_ip, user_agent, xforwardedfor, headers, request, context);
            log.trace("Deleting bitstream...");
            this.bitstreamService.delete(context, (DSpaceObject)bitstream);
            context.complete();
        }
        catch (SQLException e) {
            ItemsResource.processException((String)("Could not delete bitstream(id=" + bitstreamId + "), SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            ItemsResource.processException((String)("Could not delete bitstream(id=" + bitstreamId + "), AuthorizeException. Message: " + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        catch (IOException e) {
            ItemsResource.processException((String)("Could not delete bitstream(id=" + bitstreamId + "), IOException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            ItemsResource.processException((String)("Could not delete bitstream(id=" + bitstreamId + "), ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info("Bitstream(id=" + bitstreamId + ") from item(id=" + itemId + ") was successfuly deleted .");
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/find-by-metadata-field")
    @Produces(value={"application/json", "application/xml"})
    public Item[] findItemsByMetadataField(MetadataEntry metadataEntry, @QueryParam(value="expand") String expand, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info("Looking for item with metadata(key=" + metadataEntry.getKey() + ",value=" + metadataEntry.getValue() + ", language=" + metadataEntry.getLanguage() + ").");
        org.dspace.core.Context context = null;
        ArrayList<Item> items = new ArrayList<Item>();
        String[] metadata = this.mySplit(metadataEntry.getKey());
        if (metadata.length < 2 || metadata.length > 3) {
            log.error("Finding failed, bad metadata key.");
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        try {
            context = ItemsResource.createContext();
            Iterator itemIterator = this.itemService.findByMetadataField(context, metadataEntry.getSchema(), metadataEntry.getElement(), metadataEntry.getQualifier(), metadataEntry.getValue());
            while (itemIterator.hasNext()) {
                org.dspace.content.Item dspaceItem = (org.dspace.content.Item)itemIterator.next();
                if (!this.itemService.isItemListedForUser(context, dspaceItem)) continue;
                Item item = new Item(dspaceItem, this.servletContext, expand, context);
                this.writeStats((DSpaceObject)dspaceItem, UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
                items.add(item);
            }
            context.complete();
        }
        catch (SQLException e) {
            ItemsResource.processException((String)("Something went wrong while finding item. SQLException, Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            ItemsResource.processException((String)("Context error:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            ItemsResource.processException((String)("Authorize error:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        catch (IOException e) {
            ItemsResource.processException((String)("IO error:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        if (items.size() == 0) {
            log.info("Items not found.");
        } else {
            log.info("Items were found.");
        }
        return items.toArray(new Item[0]);
    }

    private org.dspace.content.Item findItem(org.dspace.core.Context context, String id, int action) throws WebApplicationException {
        org.dspace.content.Item item = null;
        try {
            item = (org.dspace.content.Item)this.itemService.findByIdOrLegacyId(context, id);
            if (item == null) {
                context.abort();
                log.warn("Item(id=" + id + ") was not found!");
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            if (!this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)item, action)) {
                context.abort();
                if (context.getCurrentUser() != null) {
                    log.error("User(" + context.getCurrentUser().getEmail() + ") has not permission to " + this.getActionString(action) + " item!");
                } else {
                    log.error("User(anonymous) has not permission to " + this.getActionString(action) + " item!");
                }
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
        }
        catch (SQLException e) {
            ItemsResource.processException((String)("Something get wrong while finding item(id=" + id + "). SQLException, Message: " + e), (org.dspace.core.Context)context);
        }
        return item;
    }
}

