/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Site;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.SiteService;
import org.dspace.rest.Resource;
import org.dspace.rest.common.HierarchyCollection;
import org.dspace.rest.common.HierarchyCommunity;
import org.dspace.rest.common.HierarchySite;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/hierarchy")
@Produces(value={"application/json", "application/xml"})
public class HierarchyResource
extends Resource {
    private static Logger log = LogManager.getLogger(HierarchyResource.class);
    protected SiteService siteService = ContentServiceFactory.getInstance().getSiteService();
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json", "application/xml"})
    public HierarchySite getHierarchy(@QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws UnsupportedEncodingException, WebApplicationException {
        org.dspace.core.Context context = null;
        HierarchySite repo = new HierarchySite();
        try {
            context = HierarchyResource.createContext();
            Site site = this.siteService.findSite(context);
            repo.setId(site.getID().toString());
            repo.setName(site.getName());
            repo.setHandle(site.getHandle());
            List dspaceCommunities = this.communityService.findAllTop(context);
            this.processCommunity(context, (HierarchyCommunity)repo, dspaceCommunities);
        }
        catch (Exception e) {
            HierarchyResource.processException((String)e.getMessage(), (org.dspace.core.Context)context);
        }
        finally {
            if (context != null) {
                try {
                    context.complete();
                }
                catch (SQLException e) {
                    log.error(e.getMessage() + " occurred while trying to close");
                }
            }
        }
        return repo;
    }

    private void processCommunity(org.dspace.core.Context context, HierarchyCommunity parent, List<Community> communities) throws SQLException {
        if (communities == null) {
            return;
        }
        if (communities.size() == 0) {
            return;
        }
        ArrayList<HierarchyCommunity> parentComms = new ArrayList<HierarchyCommunity>();
        parent.setCommunities(parentComms);
        for (Community comm : communities) {
            if (!this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)comm, 0)) continue;
            HierarchyCommunity mycomm = new HierarchyCommunity(comm.getID().toString(), comm.getName(), comm.getHandle());
            parentComms.add(mycomm);
            List colls = comm.getCollections();
            if (colls.size() > 0) {
                ArrayList<HierarchyCollection> myColls = new ArrayList<HierarchyCollection>();
                mycomm.setCollections(myColls);
                for (Collection coll : colls) {
                    if (!this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)coll, 0)) continue;
                    HierarchyCollection mycoll = new HierarchyCollection(coll.getID().toString(), coll.getName(), coll.getHandle());
                    myColls.add(mycoll);
                }
            }
            this.processCommunity(context, mycomm, comm.getSubcommunities());
        }
    }
}

