/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest.authentication;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authenticate.factory.AuthenticateServiceFactory;
import org.dspace.authenticate.service.AuthenticationService;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.utils.DSpace;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class DSpaceAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LogManager.getLogger();
    protected AuthenticationService authenticationService = AuthenticateServiceFactory.getInstance().getAuthenticationService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Context context = null;
        try {
            context = new Context();
            String name = authentication.getName();
            String password = authentication.getCredentials().toString();
            HttpServletRequest httpServletRequest = new DSpace().getRequestService().getCurrentRequest().getHttpServletRequest();
            ArrayList grantedAuthorities = new ArrayList();
            int implicitStatus = this.authenticationService.authenticateImplicit(context, null, null, null, httpServletRequest);
            if (implicitStatus == 1) {
                log.info(LogHelper.getHeader((Context)context, (String)"login", (String)"type=implicit"));
                this.addSpecialGroupsToGrantedAuthorityList(context, httpServletRequest, grantedAuthorities);
                Authentication authentication2 = this.createAuthenticationToken(password, context, grantedAuthorities);
                return authentication2;
            }
            int authenticateResult = this.authenticationService.authenticate(context, name, password, null, httpServletRequest);
            if (1 == authenticateResult) {
                this.addSpecialGroupsToGrantedAuthorityList(context, httpServletRequest, grantedAuthorities);
                log.info(LogHelper.getHeader((Context)context, (String)"login", (String)"type=explicit"));
                Authentication authentication3 = this.createAuthenticationToken(password, context, grantedAuthorities);
                return authentication3;
            }
            try {
                log.info(LogHelper.getHeader((Context)context, (String)"failed_login", (String)("email=" + name + ", result=" + authenticateResult)));
                throw new BadCredentialsException("Login failed");
            }
            catch (BadCredentialsException e) {
                throw e;
            }
            catch (Exception e) {
                log.error("Error while authenticating in the rest api", (Throwable)e);
            }
        }
        finally {
            if (context != null && context.isValid()) {
                try {
                    context.complete();
                }
                catch (SQLException e) {
                    log.error(e.getMessage() + " occurred while trying to close", (Throwable)e);
                }
            }
        }
        return null;
    }

    protected void addSpecialGroupsToGrantedAuthorityList(Context context, HttpServletRequest httpServletRequest, List<SimpleGrantedAuthority> grantedAuthorities) throws SQLException {
        List groups = this.authenticationService.getSpecialGroups(context, httpServletRequest);
        for (Group group : groups) {
            grantedAuthorities.add(new SimpleGrantedAuthority(group.getName()));
        }
    }

    private Authentication createAuthenticationToken(String password, Context context, List<SimpleGrantedAuthority> grantedAuthorities) {
        EPerson ePerson = context.getCurrentUser();
        if (ePerson != null && StringUtils.isNotBlank((CharSequence)ePerson.getEmail())) {
            return new UsernamePasswordAuthenticationToken((Object)ePerson.getEmail(), (Object)password, grantedAuthorities);
        }
        log.info(LogHelper.getHeader((Context)context, (String)"failed_login", (String)"No eperson with an non-blank e-mail address found"));
        throw new BadCredentialsException("Login failed");
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

