/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest.common;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletContext;
import javax.ws.rs.WebApplicationException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.rest.common.Bitstream;
import org.dspace.rest.common.Collection;
import org.dspace.rest.common.DSpaceObject;

@XmlRootElement(name="community")
public class Community
extends DSpaceObject {
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    private static Logger log = LogManager.getLogger(Community.class);
    private Bitstream logo;
    private Community parentCommunity;
    private String copyrightText;
    private String introductoryText;
    private String shortDescription;
    private String sidebarText;
    private Integer countItems;
    private List<Community> subcommunities = new ArrayList();
    private List<Collection> collections = new ArrayList();

    public Community() {
    }

    public Community(org.dspace.content.Community community, ServletContext servletContext, String expand, Context context) throws SQLException, WebApplicationException {
        super((org.dspace.content.DSpaceObject)community, servletContext);
        this.setup(community, servletContext, expand, context);
    }

    private void setup(org.dspace.content.Community community, ServletContext servletContext, String expand, Context context) throws SQLException {
        List<Object> expandFields = new ArrayList();
        if (expand != null) {
            expandFields = Arrays.asList(expand.split(","));
        }
        this.setCopyrightText(this.communityService.getMetadataFirstValue((org.dspace.content.DSpaceObject)community, DSpaceObjectService.MD_COPYRIGHT_TEXT, "*"));
        this.setIntroductoryText(this.communityService.getMetadataFirstValue((org.dspace.content.DSpaceObject)community, DSpaceObjectService.MD_INTRODUCTORY_TEXT, "*"));
        this.setShortDescription(this.communityService.getMetadataFirstValue((org.dspace.content.DSpaceObject)community, DSpaceObjectService.MD_SHORT_DESCRIPTION, "*"));
        this.setSidebarText(this.communityService.getMetadataFirstValue((org.dspace.content.DSpaceObject)community, DSpaceObjectService.MD_SIDEBAR_TEXT, "*"));
        this.setCountItems(Integer.valueOf(this.itemService.countItems(context, community)));
        if (expandFields.contains("parentCommunity") || expandFields.contains("all")) {
            org.dspace.content.Community parentCommunity = (org.dspace.content.Community)this.communityService.getParentObject(context, (org.dspace.content.DSpaceObject)community);
            if (parentCommunity != null) {
                this.setParentCommunity(new Community(parentCommunity, servletContext, null, context));
            }
        } else {
            this.addExpand("parentCommunity");
        }
        if (expandFields.contains("collections") || expandFields.contains("all")) {
            List collections = community.getCollections();
            ArrayList<Collection> restCollections = new ArrayList<Collection>();
            for (org.dspace.content.Collection collection : collections) {
                if (this.authorizeService.authorizeActionBoolean(context, (org.dspace.content.DSpaceObject)collection, 0)) {
                    restCollections.add(new Collection(collection, servletContext, null, context, null, null));
                    continue;
                }
                log.info("Omitted restricted collection: " + collection.getID() + " _ " + collection.getName());
            }
            this.setCollections(restCollections);
        } else {
            this.addExpand("collections");
        }
        if (expandFields.contains("subCommunities") || expandFields.contains("all")) {
            List communities = community.getSubcommunities();
            this.subcommunities = new ArrayList();
            for (org.dspace.content.Community subCommunity : communities) {
                if (this.authorizeService.authorizeActionBoolean(context, (org.dspace.content.DSpaceObject)subCommunity, 0)) {
                    this.subcommunities.add(new Community(subCommunity, servletContext, null, context));
                    continue;
                }
                log.info("Omitted restricted subCommunity: " + subCommunity.getID() + " _ " + subCommunity.getName());
            }
        } else {
            this.addExpand("subCommunities");
        }
        if (expandFields.contains("logo") || expandFields.contains("all")) {
            if (community.getLogo() != null) {
                this.logo = new Bitstream(community.getLogo(), servletContext, null, context);
            }
        } else {
            this.addExpand("logo");
        }
        if (!expandFields.contains("all")) {
            this.addExpand("all");
        }
    }

    public List<Collection> getCollections() {
        return this.collections;
    }

    public void setCollections(List<Collection> collections) {
        this.collections = collections;
    }

    public Integer getCountItems() {
        return this.countItems;
    }

    public void setCountItems(Integer countItems) {
        this.countItems = countItems;
    }

    public String getSidebarText() {
        return this.sidebarText;
    }

    public void setSidebarText(String sidebarText) {
        this.sidebarText = sidebarText;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getIntroductoryText() {
        return this.introductoryText;
    }

    public void setIntroductoryText(String introductoryText) {
        this.introductoryText = introductoryText;
    }

    public String getCopyrightText() {
        return this.copyrightText;
    }

    public void setCopyrightText(String copyrightText) {
        this.copyrightText = copyrightText;
    }

    public Community getParentCommunity() {
        return this.parentCommunity;
    }

    public void setParentCommunity(Community parentCommunity) {
        this.parentCommunity = parentCommunity;
    }

    public Bitstream getLogo() {
        return this.logo;
    }

    public void setLogo(Bitstream logo) {
        this.logo = logo;
    }

    @XmlElement(name="subcommunities", required=true)
    public List<Community> getSubcommunities() {
        return this.subcommunities;
    }

    public void setSubcommunities(List<Community> subcommunities) {
        this.subcommunities = subcommunities;
    }
}

