/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest.common;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.xml.bind.annotation.XmlRootElement;
import org.dspace.app.util.Util;
import org.dspace.eperson.EPerson;

@XmlRootElement(name="status")
public class Status {
    private boolean okay;
    private boolean authenticated;
    private String email;
    private String fullname;
    private String sourceVersion;
    private String apiVersion;

    public Status() {
        this.setOkay(true);
        this.setSourceVersion(Util.getSourceVersion());
        String[] version = Util.getSourceVersion().split("\\.");
        this.setApiVersion(version[0]);
        this.setAuthenticated(false);
    }

    public Status(String email, String fullname) {
        this.setOkay(true);
        this.setAuthenticated(true);
        this.setEmail(email);
        this.setFullname(fullname);
    }

    public Status(EPerson eperson) {
        this.setOkay(true);
        if (eperson != null) {
            this.setAuthenticated(true);
            this.setEmail(eperson.getEmail());
            this.setFullname(eperson.getFullName());
        } else {
            this.setAuthenticated(false);
        }
    }

    @JsonProperty(value="okay")
    public boolean isOkay() {
        return this.okay;
    }

    public void setOkay(boolean okay) {
        this.okay = okay;
    }

    @JsonProperty(value="authenticated")
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @JsonProperty(value="fullname")
    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    @JsonProperty(value="sourceVersion")
    public String getSourceVersion() {
        return this.sourceVersion;
    }

    public void setSourceVersion(String sourceVersion) {
        this.sourceVersion = sourceVersion;
    }

    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }
}

