/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest.common;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletContext;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Bundle;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.core.Context;
import org.dspace.rest.common.CheckSum;
import org.dspace.rest.common.DSpaceObject;
import org.dspace.rest.common.ResourcePolicy;
import org.dspace.utils.DSpace;

@XmlRootElement(name="bitstream")
public class Bitstream
extends DSpaceObject {
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    Logger log = LogManager.getLogger(Bitstream.class);
    private String bundleName;
    private String description;
    private String format;
    private String mimeType;
    private Long sizeBytes;
    private DSpaceObject parentObject;
    private String retrieveLink;
    private CheckSum checkSum;
    private Integer sequenceId;
    private ResourcePolicy[] policies = null;

    public Bitstream() {
    }

    public Bitstream(org.dspace.content.Bitstream bitstream, ServletContext servletContext, String expand, Context context) throws SQLException {
        super((org.dspace.content.DSpaceObject)bitstream, servletContext);
        this.setup(bitstream, servletContext, expand, context);
    }

    public void setup(org.dspace.content.Bitstream bitstream, ServletContext servletContext, String expand, Context context) throws SQLException {
        List<Object> expandFields = new ArrayList();
        if (expand != null) {
            expandFields = Arrays.asList(expand.split(","));
        }
        if (bitstream.getBundles() != null && !bitstream.getBundles().isEmpty() && this.bitstreamService.getParentObject(context, (org.dspace.content.DSpaceObject)bitstream).getType() == 2) {
            this.bundleName = ((Bundle)bitstream.getBundles().get(0)).getName();
        }
        this.description = bitstream.getDescription();
        this.format = this.bitstreamService.getFormatDescription(context, bitstream);
        this.sizeBytes = bitstream.getSizeBytes();
        String path = new DSpace().getRequestService().getCurrentRequest().getHttpServletRequest().getContextPath();
        this.retrieveLink = path + "/bitstreams/" + bitstream.getID() + "/retrieve";
        this.mimeType = this.bitstreamService.getFormat(context, bitstream).getMIMEType();
        this.sequenceId = bitstream.getSequenceID();
        CheckSum checkSum = new CheckSum();
        checkSum.setCheckSumAlgorith(bitstream.getChecksumAlgorithm());
        checkSum.setValue(bitstream.getChecksum());
        this.setCheckSum(checkSum);
        if (expandFields.contains("parent") || expandFields.contains("all")) {
            this.parentObject = new DSpaceObject(this.bitstreamService.getParentObject(context, (org.dspace.content.DSpaceObject)bitstream), servletContext);
        } else {
            this.addExpand("parent");
        }
        if (expandFields.contains("policies") || expandFields.contains("all")) {
            ArrayList<ResourcePolicy> tempPolicies = new ArrayList<ResourcePolicy>();
            List bundles = bitstream.getBundles();
            for (Bundle bundle : bundles) {
                List bitstreamsPolicies = this.bundleService.getBitstreamPolicies(context, bundle);
                for (org.dspace.authorize.ResourcePolicy policy : bitstreamsPolicies) {
                    if (!policy.getdSpaceObject().equals(bitstream)) continue;
                    tempPolicies.add(new ResourcePolicy(policy));
                }
            }
            this.policies = tempPolicies.toArray(new ResourcePolicy[0]);
        } else {
            this.addExpand("policies");
        }
        if (!expandFields.contains("all")) {
            this.addExpand("all");
        }
    }

    public Integer getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(Integer sequenceId) {
        this.sequenceId = sequenceId;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setSizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
    }

    public void setParentObject(DSpaceObject parentObject) {
        this.parentObject = parentObject;
    }

    public void setRetrieveLink(String retrieveLink) {
        this.retrieveLink = retrieveLink;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFormat() {
        return this.format;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    public String getRetrieveLink() {
        return this.retrieveLink;
    }

    public DSpaceObject getParentObject() {
        return this.parentObject;
    }

    public CheckSum getCheckSum() {
        return this.checkSum;
    }

    public void setCheckSum(CheckSum checkSum) {
        this.checkSum = checkSum;
    }

    public ResourcePolicy[] getPolicies() {
        return this.policies;
    }

    public void setPolicies(ResourcePolicy[] policies) {
        this.policies = policies;
    }
}

