/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.rest.Resource;
import org.dspace.rest.common.FilteredCollection;
import org.dspace.rest.exceptions.ContextException;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.usage.UsageEvent;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/filtered-collections")
public class FilteredCollectionsResource
extends Resource {
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private static Logger log = LogManager.getLogger(FilteredCollectionsResource.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json", "application/xml"})
    public FilteredCollection[] getCollections(@QueryParam(value="expand") String expand, @QueryParam(value="limit") @DefaultValue(value="100") Integer limit, @QueryParam(value="offset") @DefaultValue(value="0") Integer offset, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="filters") @DefaultValue(value="is_item") String filters, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context ServletContext servletContext, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info("Reading all filtered collections.(offset=" + offset + ",limit=" + limit + ")");
        org.dspace.core.Context context = null;
        ArrayList<FilteredCollection> collections = new ArrayList<FilteredCollection>();
        try {
            context = FilteredCollectionsResource.createContext();
            if (limit == null || limit < 0 || offset == null || offset < 0) {
                log.warn("Paging was badly set.");
                limit = 100;
                offset = 0;
            }
            List dspaceCollections = this.collectionService.findAll(context, limit, offset);
            for (Collection dspaceCollection : dspaceCollections) {
                if (!this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)dspaceCollection, 0)) continue;
                FilteredCollection collection = new FilteredCollection(dspaceCollection, servletContext, filters, expand, context, limit, offset);
                collections.add(collection);
                this.writeStats((DSpaceObject)dspaceCollection, UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
            }
            context.complete();
        }
        catch (SQLException e) {
            FilteredCollectionsResource.processException((String)("Something went wrong while reading collections from database. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            FilteredCollectionsResource.processException((String)("Something went wrong while reading collections, ContextError. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.trace("All collections were successfully read.");
        return collections.toArray(new FilteredCollection[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{collection_id}")
    @Produces(value={"application/json", "application/xml"})
    public FilteredCollection getCollection(@PathParam(value="collection_id") String collection_id, @QueryParam(value="expand") String expand, @QueryParam(value="limit") @DefaultValue(value="1000") Integer limit, @QueryParam(value="offset") @DefaultValue(value="0") Integer offset, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @QueryParam(value="filters") @DefaultValue(value="is_item") String filters, @Context HttpHeaders headers, @Context HttpServletRequest request, @Context ServletContext servletContext) {
        org.dspace.core.Context context = null;
        FilteredCollection retColl = new FilteredCollection();
        try {
            context = FilteredCollectionsResource.createContext();
            Collection collection = (Collection)this.collectionService.findByIdOrLegacyId(context, collection_id);
            if (!this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)collection, 0)) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            this.writeStats((DSpaceObject)collection, UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
            retColl = new FilteredCollection(collection, servletContext, filters, expand, context, limit, offset);
            context.complete();
        }
        catch (SQLException e) {
            FilteredCollectionsResource.processException((String)e.getMessage(), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            FilteredCollectionsResource.processException((String)String.format("Could not read collection %s.  %s", collection_id, e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        return retColl;
    }
}

