/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.rest.Resource;
import org.dspace.rest.common.Collection;
import org.dspace.rest.common.Community;
import org.dspace.rest.exceptions.ContextException;
import org.dspace.usage.UsageEvent;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/communities")
public class CommunitiesResource
extends Resource {
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    private static final Logger log = LogManager.getLogger(CommunitiesResource.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{community_id}")
    @Produces(value={"application/json", "application/xml"})
    public Community getCommunity(@PathParam(value="community_id") String communityId, @QueryParam(value="expand") String expand, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info("Reading community(id=" + communityId + ").");
        org.dspace.core.Context context = null;
        Community community = null;
        try {
            context = CommunitiesResource.createContext();
            org.dspace.content.Community dspaceCommunity = this.findCommunity(context, communityId, 0);
            this.writeStats((DSpaceObject)dspaceCommunity, UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
            community = new Community(dspaceCommunity, this.servletContext, expand, context);
            context.complete();
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Could not read community(id=" + communityId + "), SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CommunitiesResource.processException((String)("Could not read community(id=" + communityId + "), ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.trace("Community(id=" + communityId + ") was successfully read.");
        return community;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json", "application/xml"})
    public Community[] getCommunities(@QueryParam(value="expand") String expand, @QueryParam(value="limit") @DefaultValue(value="100") Integer limit, @QueryParam(value="offset") @DefaultValue(value="0") Integer offset, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info("Reading all communities.(offset=" + offset + " ,limit=" + limit + ").");
        org.dspace.core.Context context = null;
        ArrayList<Community> communities = null;
        try {
            context = CommunitiesResource.createContext();
            List dspaceCommunities = this.communityService.findAll(context);
            communities = new ArrayList<Community>();
            if (limit == null || limit < 0 || offset == null || offset < 0) {
                log.warn("Paging was badly set, using default values.");
                limit = 100;
                offset = 0;
            }
            for (int i = offset.intValue(); i < offset + limit && i < dspaceCommunities.size(); ++i) {
                if (!this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)dspaceCommunities.get(i), 0)) continue;
                Community community = new Community((org.dspace.content.Community)dspaceCommunities.get(i), this.servletContext, expand, context);
                this.writeStats((DSpaceObject)dspaceCommunities.get(i), UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
                communities.add(community);
            }
            context.complete();
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Could not read communities, SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CommunitiesResource.processException((String)("Could not read communities, ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.trace("All communities successfully read.");
        return communities.toArray(new Community[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/top-communities")
    @Produces(value={"application/json", "application/xml"})
    public Community[] getTopCommunities(@QueryParam(value="expand") String expand, @QueryParam(value="limit") @DefaultValue(value="20") Integer limit, @QueryParam(value="offset") @DefaultValue(value="0") Integer offset, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info("Reading all top communities.(offset=" + offset + " ,limit=" + limit + ").");
        org.dspace.core.Context context = null;
        ArrayList<Community> communities = null;
        try {
            context = CommunitiesResource.createContext();
            List dspaceCommunities = this.communityService.findAllTop(context);
            communities = new ArrayList<Community>();
            if (limit == null || limit < 0 || offset == null || offset < 0) {
                log.warn("Paging was badly set, using default values.");
                limit = 100;
                offset = 0;
            }
            for (int i = offset.intValue(); i < offset + limit && i < dspaceCommunities.size(); ++i) {
                if (!this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)dspaceCommunities.get(i), 0)) continue;
                Community community = new Community((org.dspace.content.Community)dspaceCommunities.get(i), this.servletContext, expand, context);
                this.writeStats((DSpaceObject)dspaceCommunities.get(i), UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
                communities.add(community);
            }
            context.complete();
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Could not read top communities, SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CommunitiesResource.processException((String)("Could not read top communities, ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.trace("All top communities successfully read.");
        return communities.toArray(new Community[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{community_id}/collections")
    @Produces(value={"application/json", "application/xml"})
    public Collection[] getCommunityCollections(@PathParam(value="community_id") String communityId, @QueryParam(value="expand") String expand, @QueryParam(value="limit") @DefaultValue(value="100") Integer limit, @QueryParam(value="offset") @DefaultValue(value="0") Integer offset, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info("Reading community(id=" + communityId + ") collections.");
        org.dspace.core.Context context = null;
        ArrayList<Collection> collections = null;
        try {
            context = CommunitiesResource.createContext();
            org.dspace.content.Community dspaceCommunity = this.findCommunity(context, communityId, 0);
            this.writeStats((DSpaceObject)dspaceCommunity, UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
            if (limit == null || limit < 0 || offset == null || offset < 0) {
                log.warn("Pagging was badly set, using default values.");
                limit = 100;
                offset = 0;
            }
            collections = new ArrayList<Collection>();
            List dspaceCollections = dspaceCommunity.getCollections();
            for (int i = offset.intValue(); i < offset + limit && i < dspaceCollections.size(); ++i) {
                if (!this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)dspaceCollections.get(i), 0)) continue;
                collections.add(new Collection((org.dspace.content.Collection)dspaceCollections.get(i), this.servletContext, expand, context, Integer.valueOf(20), Integer.valueOf(0)));
                this.writeStats((DSpaceObject)dspaceCollections.get(i), UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
            }
            context.complete();
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Could not read community(id=" + communityId + ") collections, SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CommunitiesResource.processException((String)("Could not read community(id=" + communityId + ") collections, ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.trace("Community(id=" + communityId + ") collections were successfully read.");
        return collections.toArray(new Collection[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{community_id}/communities")
    @Produces(value={"application/json", "application/xml"})
    public Community[] getCommunityCommunities(@PathParam(value="community_id") String communityId, @QueryParam(value="expand") String expand, @QueryParam(value="limit") @DefaultValue(value="20") Integer limit, @QueryParam(value="offset") @DefaultValue(value="0") Integer offset, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info("Reading community(id=" + communityId + ") subcommunities.");
        org.dspace.core.Context context = null;
        ArrayList<Community> communities = null;
        try {
            context = CommunitiesResource.createContext();
            org.dspace.content.Community dspaceCommunity = this.findCommunity(context, communityId, 0);
            this.writeStats((DSpaceObject)dspaceCommunity, UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
            if (limit == null || limit < 0 || offset == null || offset < 0) {
                log.warn("Pagging was badly set, using default values.");
                limit = 100;
                offset = 0;
            }
            communities = new ArrayList<Community>();
            List dspaceCommunities = dspaceCommunity.getSubcommunities();
            for (int i = offset.intValue(); i < offset + limit && i < dspaceCommunities.size(); ++i) {
                if (!this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)dspaceCommunities.get(i), 0)) continue;
                communities.add(new Community((org.dspace.content.Community)dspaceCommunities.get(i), this.servletContext, expand, context));
                this.writeStats((DSpaceObject)dspaceCommunities.get(i), UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
            }
            context.complete();
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Could not read community(id=" + communityId + ") subcommunities, SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CommunitiesResource.processException((String)("Could not read community(id=" + communityId + ") subcommunities, ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.trace("Community(id=" + communityId + ") subcommunities were successfully read.");
        return communities.toArray(new Community[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/json", "application/xml"})
    public Community createCommunity(Community community, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info("Creating community at top level.");
        org.dspace.core.Context context = null;
        Community retCommunity = null;
        try {
            context = CommunitiesResource.createContext();
            if (!this.authorizeService.isAdmin(context)) {
                context.abort();
                String user = "anonymous";
                if (context.getCurrentUser() != null) {
                    user = context.getCurrentUser().getEmail();
                }
                log.error("User(" + user + ") has not permission to create community!");
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            org.dspace.content.Community dspaceCommunity = this.communityService.create(null, context);
            this.writeStats((DSpaceObject)dspaceCommunity, UsageEvent.Action.CREATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            this.communityService.setMetadataSingleValue(context, (DSpaceObject)dspaceCommunity, DSpaceObjectService.MD_NAME, community.getName(), null);
            this.communityService.setMetadataSingleValue(context, (DSpaceObject)dspaceCommunity, DSpaceObjectService.MD_COPYRIGHT_TEXT, community.getCopyrightText(), null);
            this.communityService.setMetadataSingleValue(context, (DSpaceObject)dspaceCommunity, DSpaceObjectService.MD_INTRODUCTORY_TEXT, community.getIntroductoryText(), null);
            this.communityService.setMetadataSingleValue(context, (DSpaceObject)dspaceCommunity, DSpaceObjectService.MD_SHORT_DESCRIPTION, community.getShortDescription(), null);
            this.communityService.setMetadataSingleValue(context, (DSpaceObject)dspaceCommunity, DSpaceObjectService.MD_SIDEBAR_TEXT, community.getSidebarText(), null);
            this.communityService.update(context, (DSpaceObject)dspaceCommunity);
            retCommunity = new Community(dspaceCommunity, this.servletContext, "", context);
            context.complete();
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Could not create new top community, SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CommunitiesResource.processException((String)("Could not create new top community, ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            CommunitiesResource.processException((String)("Could not create new top community, AuthorizeException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info("Community at top level has been successfully created. Handle:" + retCommunity.getHandle());
        return retCommunity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{community_id}/collections")
    @Consumes(value={"application/json", "application/xml"})
    public Collection addCommunityCollection(@PathParam(value="community_id") String communityId, Collection collection, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info("Adding collection into community(id=" + communityId + ").");
        org.dspace.core.Context context = null;
        Collection retCollection = null;
        try {
            context = CommunitiesResource.createContext();
            org.dspace.content.Community dspaceCommunity = this.findCommunity(context, communityId, 1);
            this.writeStats((DSpaceObject)dspaceCommunity, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            org.dspace.content.Collection dspaceCollection = this.collectionService.create(context, dspaceCommunity);
            this.collectionService.setMetadataSingleValue(context, (DSpaceObject)dspaceCollection, DSpaceObjectService.MD_LICENSE, collection.getLicense(), null);
            this.collectionService.setMetadataSingleValue(context, (DSpaceObject)dspaceCollection, DSpaceObjectService.MD_NAME, collection.getName(), null);
            this.collectionService.setMetadataSingleValue(context, (DSpaceObject)dspaceCollection, DSpaceObjectService.MD_COPYRIGHT_TEXT, collection.getCopyrightText(), null);
            this.collectionService.setMetadataSingleValue(context, (DSpaceObject)dspaceCollection, DSpaceObjectService.MD_INTRODUCTORY_TEXT, collection.getIntroductoryText(), null);
            this.collectionService.setMetadataSingleValue(context, (DSpaceObject)dspaceCollection, DSpaceObjectService.MD_SHORT_DESCRIPTION, collection.getShortDescription(), null);
            this.collectionService.setMetadataSingleValue(context, (DSpaceObject)dspaceCollection, DSpaceObjectService.MD_SIDEBAR_TEXT, collection.getSidebarText(), null);
            this.collectionService.update(context, (DSpaceObject)dspaceCollection);
            this.communityService.update(context, (DSpaceObject)dspaceCommunity);
            retCollection = new Collection(dspaceCollection, this.servletContext, "", context, Integer.valueOf(100), Integer.valueOf(0));
            context.complete();
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Could not add collection into community(id=" + communityId + "), SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            CommunitiesResource.processException((String)("Could not add collection into community(id=" + communityId + "), AuthorizeException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CommunitiesResource.processException((String)("Could not add collection into community(id=" + communityId + "), ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info("Collection was successfully added into community(id=" + communityId + "). Collection handle=" + retCollection.getHandle());
        return retCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{community_id}/communities")
    @Consumes(value={"application/json", "application/xml"})
    public Community addCommunityCommunity(@PathParam(value="community_id") String communityId, Community community, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info("Add subcommunity into community(id=" + communityId + ").");
        org.dspace.core.Context context = null;
        Community retCommunity = null;
        try {
            context = CommunitiesResource.createContext();
            org.dspace.content.Community dspaceParentCommunity = this.findCommunity(context, communityId, 1);
            this.writeStats((DSpaceObject)dspaceParentCommunity, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            org.dspace.content.Community dspaceCommunity = this.communityService.createSubcommunity(context, dspaceParentCommunity);
            this.communityService.setMetadataSingleValue(context, (DSpaceObject)dspaceCommunity, DSpaceObjectService.MD_NAME, community.getName(), null);
            this.communityService.setMetadataSingleValue(context, (DSpaceObject)dspaceCommunity, DSpaceObjectService.MD_COPYRIGHT_TEXT, community.getCopyrightText(), null);
            this.communityService.setMetadataSingleValue(context, (DSpaceObject)dspaceCommunity, DSpaceObjectService.MD_INTRODUCTORY_TEXT, community.getIntroductoryText(), null);
            this.communityService.setMetadataSingleValue(context, (DSpaceObject)dspaceCommunity, DSpaceObjectService.MD_SHORT_DESCRIPTION, community.getShortDescription(), null);
            this.communityService.setMetadataSingleValue(context, (DSpaceObject)dspaceCommunity, DSpaceObjectService.MD_SIDEBAR_TEXT, community.getSidebarText(), null);
            this.communityService.update(context, (DSpaceObject)dspaceCommunity);
            this.communityService.update(context, (DSpaceObject)dspaceParentCommunity);
            retCommunity = new Community(dspaceCommunity, this.servletContext, "", context);
            context.complete();
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Could not add subcommunity into community(id=" + communityId + "), SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            CommunitiesResource.processException((String)("Could not add subcommunity into community(id=" + communityId + "), AuthorizeException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CommunitiesResource.processException((String)("Could not add subcommunity into community(id=" + communityId + "), ContextException. Message:" + e), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info("Subcommunity was successfully added in community(id=" + communityId + ").");
        return retCommunity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/{community_id}")
    @Consumes(value={"application/json", "application/xml"})
    public Response updateCommunity(@PathParam(value="community_id") String communityId, Community community, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info("Updating community(id=" + communityId + ").");
        org.dspace.core.Context context = null;
        try {
            context = CommunitiesResource.createContext();
            org.dspace.content.Community dspaceCommunity = this.findCommunity(context, communityId, 1);
            this.writeStats((DSpaceObject)dspaceCommunity, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            this.communityService.setMetadataSingleValue(context, (DSpaceObject)dspaceCommunity, DSpaceObjectService.MD_NAME, community.getName(), null);
            this.communityService.setMetadataSingleValue(context, (DSpaceObject)dspaceCommunity, DSpaceObjectService.MD_COPYRIGHT_TEXT, community.getCopyrightText(), null);
            this.communityService.setMetadataSingleValue(context, (DSpaceObject)dspaceCommunity, DSpaceObjectService.MD_INTRODUCTORY_TEXT, community.getIntroductoryText(), null);
            this.communityService.setMetadataSingleValue(context, (DSpaceObject)dspaceCommunity, DSpaceObjectService.MD_SHORT_DESCRIPTION, community.getShortDescription(), null);
            this.communityService.setMetadataSingleValue(context, (DSpaceObject)dspaceCommunity, DSpaceObjectService.MD_SIDEBAR_TEXT, community.getSidebarText(), null);
            this.communityService.update(context, (DSpaceObject)dspaceCommunity);
            context.complete();
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Could not update community(id=" + communityId + "), AuthorizeException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CommunitiesResource.processException((String)("Could not update community(id=" + communityId + "), ContextException Message:" + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            CommunitiesResource.processException((String)("Could not update community(id=" + communityId + "), AuthorizeException Message:" + e), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info("Community(id=" + communityId + ") has been successfully updated.");
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{community_id}")
    public Response deleteCommunity(@PathParam(value="community_id") String communityId, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info("Deleting community(id=" + communityId + ").");
        org.dspace.core.Context context = null;
        try {
            context = CommunitiesResource.createContext();
            org.dspace.content.Community community = this.findCommunity(context, communityId, 2);
            this.writeStats((DSpaceObject)community, UsageEvent.Action.DELETE, user_ip, user_agent, xforwardedfor, headers, request, context);
            this.communityService.delete(context, (DSpaceObject)community);
            this.communityService.update(context, (DSpaceObject)community);
            context.complete();
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Could not delete community(id=" + communityId + "), SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            CommunitiesResource.processException((String)("Could not delete community(id=" + communityId + "), AuthorizeException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (IOException e) {
            CommunitiesResource.processException((String)("Could not delete community(id=" + communityId + "), IOException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CommunitiesResource.processException((String)("Could not delete community(id=" + communityId + "), ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info("Community(id=" + communityId + ") was successfully deleted.");
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{community_id}/collections/{collection_id}")
    public Response deleteCommunityCollection(@PathParam(value="community_id") String communityId, @PathParam(value="collection_id") String collectionId, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info("Deleting collection(id=" + collectionId + ") in community(id=" + communityId + ").");
        org.dspace.core.Context context = null;
        try {
            context = CommunitiesResource.createContext();
            org.dspace.content.Community community = this.findCommunity(context, communityId, 1);
            org.dspace.content.Collection collection = (org.dspace.content.Collection)this.collectionService.findByIdOrLegacyId(context, collectionId);
            if (collection == null) {
                context.abort();
                log.warn("Collection(id=" + collectionId + ") was not found!");
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            if (!this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)collection, 4)) {
                context.abort();
                if (context.getCurrentUser() != null) {
                    log.error("User(" + context.getCurrentUser().getEmail() + ") has not permission to delete collection!");
                } else {
                    log.error("User(anonymous) has not permission to delete collection!");
                }
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            this.communityService.removeCollection(context, community, collection);
            this.communityService.update(context, (DSpaceObject)community);
            this.collectionService.update(context, (DSpaceObject)collection);
            this.writeStats((DSpaceObject)community, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            this.writeStats((DSpaceObject)collection, UsageEvent.Action.DELETE, user_ip, user_agent, xforwardedfor, headers, request, context);
            context.complete();
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Could not delete collection(id=" + collectionId + ") in community(id=" + communityId + "), SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            CommunitiesResource.processException((String)("Could not delete collection(id=" + collectionId + ") in community(id=" + communityId + "), AuthorizeException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (IOException e) {
            CommunitiesResource.processException((String)("Could not delete collection(id=" + collectionId + ") in community(id=" + communityId + "), IOException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CommunitiesResource.processException((String)("Could not delete collection(id=" + collectionId + ") in community(id=" + communityId + "), ContextExcpetion. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info("Collection(id=" + collectionId + ") in community(id=" + communityId + ") was successfully deleted.");
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{community_id}/communities/{community_id2}")
    public Response deleteCommunityCommunity(@PathParam(value="community_id") String parentCommunityId, @PathParam(value="community_id2") String subcommunityId, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info("Deleting community(id=" + parentCommunityId + ").");
        org.dspace.core.Context context = null;
        try {
            context = CommunitiesResource.createContext();
            org.dspace.content.Community parentCommunity = this.findCommunity(context, parentCommunityId, 1);
            org.dspace.content.Community subcommunity = (org.dspace.content.Community)this.communityService.findByIdOrLegacyId(context, subcommunityId);
            if (subcommunity == null) {
                context.abort();
                log.warn("Subcommunity(id=" + subcommunityId + ") in community(id=) was not found!");
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            if (!this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)subcommunity, 4)) {
                context.abort();
                if (context.getCurrentUser() != null) {
                    log.error("User(" + context.getCurrentUser().getEmail() + ") has not permission to delete community!");
                } else {
                    log.error("User(anonymous) has not permission to delete community!");
                }
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            this.communityService.removeSubcommunity(context, parentCommunity, subcommunity);
            this.communityService.update(context, (DSpaceObject)parentCommunity);
            this.communityService.update(context, (DSpaceObject)subcommunity);
            this.writeStats((DSpaceObject)parentCommunity, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            this.writeStats((DSpaceObject)subcommunity, UsageEvent.Action.DELETE, user_ip, user_agent, xforwardedfor, headers, request, context);
            context.complete();
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Could not delete subcommunity(id=" + subcommunityId + ") in community(id=" + parentCommunityId + "), SQLException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            CommunitiesResource.processException((String)("Could not delete subcommunity(id=" + subcommunityId + ") in community(id=" + parentCommunityId + "), AuthorizeException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (IOException e) {
            CommunitiesResource.processException((String)("Could not delete subcommunity(id=" + subcommunityId + ") in community(id=" + parentCommunityId + "), IOException. Message:" + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CommunitiesResource.processException((String)("Could not delete subcommunity(id=" + subcommunityId + ") in community(id=" + parentCommunityId + "), ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info("Subcommunity(id=" + subcommunityId + ") from community(id=" + parentCommunityId + ") was successfully deleted.");
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private org.dspace.content.Community findCommunity(org.dspace.core.Context context, String id, int action) throws WebApplicationException {
        org.dspace.content.Community community = null;
        try {
            community = (org.dspace.content.Community)this.communityService.findByIdOrLegacyId(context, id);
            if (community == null) {
                context.abort();
                log.warn("Community(id=" + id + ") was not found!");
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            if (!this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)community, action)) {
                context.abort();
                if (context.getCurrentUser() != null) {
                    log.error("User(" + context.getCurrentUser().getEmail() + ") has not permission to " + this.getActionString(action) + " community!");
                } else {
                    log.error("User(anonymous) has not permission to " + this.getActionString(action) + " community!");
                }
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
        }
        catch (SQLException e) {
            CommunitiesResource.processException((String)("Something get wrong while finding community(id=" + id + "). SQLException, Message:" + e), (org.dspace.core.Context)context);
        }
        return community;
    }
}

