/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.IOException;
import java.sql.SQLException;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.GroupRest;
import org.dspace.app.rest.model.RestModel;
import org.dspace.app.rest.model.hateoas.GroupResource;
import org.dspace.app.rest.repository.CommunityRestRepository;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Community;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/core/communities/{uuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}/adminGroup"})
public class CommunityAdminGroupRestController {
    @Autowired
    private CommunityService communityService;
    @Autowired
    private CommunityRestRepository communityRestRepository;
    @Autowired
    private ConverterService converterService;
    @Autowired
    private AuthorizeService authorizeService;

    @RequestMapping(method={RequestMethod.POST})
    @PreAuthorize(value="hasPermission(#uuid, 'COMMUNITY', 'WRITE')")
    public ResponseEntity<ResourceSupport> postAdminGroup(@PathVariable UUID uuid, HttpServletResponse response, HttpServletRequest request) throws SQLException, AuthorizeException {
        Context context = ContextUtil.obtainContext((ServletRequest)request);
        Community community = (Community)this.communityService.find(context, uuid);
        if (community == null) {
            throw new ResourceNotFoundException("No such community: " + uuid);
        }
        AuthorizeUtil.authorizeManageAdminGroup((Context)context, (Community)community);
        if (community.getAdministrators() != null) {
            throw new UnprocessableEntityException("The community with UUID: " + uuid + " already has an admin group");
        }
        GroupRest adminGroup = this.communityRestRepository.createAdminGroup(context, request, community);
        context.complete();
        GroupResource groupResource = (GroupResource)this.converterService.toResource((RestModel)adminGroup);
        return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.CREATED, (HttpHeaders)new HttpHeaders(), (ResourceSupport)groupResource);
    }

    @RequestMapping(method={RequestMethod.DELETE})
    @PreAuthorize(value="hasPermission(#uuid, 'COMMUNITY', 'WRITE')")
    public ResponseEntity<ResourceSupport> deleteAdminGroup(@PathVariable UUID uuid, HttpServletResponse response, HttpServletRequest request) throws SQLException, AuthorizeException, IOException {
        Context context = ContextUtil.obtainContext((ServletRequest)request);
        Community community = (Community)this.communityService.find(context, uuid);
        if (community == null) {
            throw new ResourceNotFoundException("No such community: " + uuid);
        }
        AuthorizeUtil.authorizeManageAdminGroup((Context)context, (Community)community);
        if (community.getAdministrators() == null) {
            throw new UnprocessableEntityException("The community with UUID: " + uuid + " doesn't have an admin group");
        }
        this.communityRestRepository.deleteAdminGroup(context, community);
        context.complete();
        return ControllerUtils.toEmptyResponse((HttpStatus)HttpStatus.NO_CONTENT);
    }
}

