/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.BitstreamFormatRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.bitstreamformat")
public class BitstreamFormatRestRepository
extends DSpaceRestRepository<BitstreamFormatRest, Integer> {
    @Autowired
    BitstreamFormatService bitstreamFormatService;

    public BitstreamFormatRest findOne(Context context, Integer id) {
        BitstreamFormat bit = null;
        try {
            bit = (BitstreamFormat)this.bitstreamFormatService.find(context, id.intValue());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (bit == null) {
            return null;
        }
        return (BitstreamFormatRest)this.converter.toRest((Object)bit, this.utils.obtainProjection());
    }

    public Page<BitstreamFormatRest> findAll(Context context, Pageable pageable) {
        try {
            List bit = this.bitstreamFormatService.findAll(context);
            return this.converter.toRestPage(this.utils.getPage(bit, pageable), this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected BitstreamFormatRest createAndReturn(Context context) throws AuthorizeException {
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        ObjectMapper mapper = new ObjectMapper();
        BitstreamFormatRest bitstreamFormatRest = null;
        try {
            ServletInputStream input = req.getInputStream();
            bitstreamFormatRest = (BitstreamFormatRest)mapper.readValue((InputStream)input, BitstreamFormatRest.class);
        }
        catch (IOException e1) {
            throw new UnprocessableEntityException("Error parsing request body", (Throwable)e1);
        }
        BitstreamFormat bitstreamFormat = null;
        try {
            bitstreamFormat = (BitstreamFormat)this.bitstreamFormatService.create(context);
            this.setAllValuesOfRest(context, bitstreamFormat, bitstreamFormatRest);
            this.bitstreamFormatService.update(context, (Object)bitstreamFormat);
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to create new bitstream format with description: " + bitstreamFormatRest.getShortDescription(), e);
        }
        return (BitstreamFormatRest)this.converter.toRest((Object)bitstreamFormat, this.utils.obtainProjection());
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected BitstreamFormatRest put(Context context, HttpServletRequest request, String apiCategory, String model, Integer id, JsonNode jsonNode) throws SQLException, AuthorizeException {
        BitstreamFormatRest bitstreamFormatRest = null;
        try {
            bitstreamFormatRest = (BitstreamFormatRest)new ObjectMapper().readValue(jsonNode.toString(), BitstreamFormatRest.class);
        }
        catch (IOException e) {
            throw new UnprocessableEntityException("Error parsing collection json: " + e.getMessage());
        }
        BitstreamFormat bitstreamFormat = null;
        String notFoundException = "ResourceNotFoundException:" + apiCategory + "." + model + " with id: " + id + " not found";
        try {
            bitstreamFormat = (BitstreamFormat)this.bitstreamFormatService.find(context, id.intValue());
            if (bitstreamFormat == null) {
                throw new ResourceNotFoundException(notFoundException);
            }
        }
        catch (SQLException e) {
            throw new ResourceNotFoundException(notFoundException);
        }
        if (id.equals(bitstreamFormatRest.getId())) {
            this.setAllValuesOfRest(context, bitstreamFormat, bitstreamFormatRest);
            this.bitstreamFormatService.update(context, (Object)bitstreamFormat);
            return (BitstreamFormatRest)this.converter.toRest((Object)bitstreamFormat, this.utils.obtainProjection());
        }
        throw new IllegalArgumentException("The id in the Json and the id in the url do not match: " + id + ", " + bitstreamFormatRest.getId());
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected void delete(Context context, Integer id) throws AuthorizeException {
        BitstreamFormat bitstreamFormat = null;
        String notFoundException = "ResourceNotFoundException:core.bitstreamformat with id: " + id + " not found";
        try {
            bitstreamFormat = (BitstreamFormat)this.bitstreamFormatService.find(context, id.intValue());
            if (bitstreamFormat == null) {
                throw new ResourceNotFoundException(notFoundException);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("RuntimeException: Unable to find BitstreamFormat with id = " + id, e);
        }
        try {
            this.bitstreamFormatService.delete(context, (Object)bitstreamFormat);
        }
        catch (SQLException e) {
            throw new RuntimeException("RuntimeException: Unable to delete BitstreamFormat with id  = " + id, e);
        }
    }

    private void setAllValuesOfRest(Context c, BitstreamFormat bitstreamFormat, BitstreamFormatRest bitstreamFormatRest) {
        try {
            bitstreamFormat.setShortDescription(c, bitstreamFormatRest.getShortDescription());
        }
        catch (SQLException e) {
            throw new RuntimeException("RuntimeException: Unable to set the short description (" + bitstreamFormatRest.getShortDescription() + ") for bitstream", e);
        }
        bitstreamFormat.setDescription(bitstreamFormatRest.getDescription());
        bitstreamFormat.setMIMEType(bitstreamFormatRest.getMimetype());
        int supportLevelID = this.bitstreamFormatService.getSupportLevelID(bitstreamFormatRest.getSupportLevel());
        if (supportLevelID == -1) {
            throw new DSpaceBadRequestException("Not a valid supportLevel: " + bitstreamFormatRest.getSupportLevel());
        }
        bitstreamFormat.setSupportLevel(supportLevelID);
        bitstreamFormat.setInternal(bitstreamFormatRest.isInternal());
        bitstreamFormat.setExtensions(bitstreamFormatRest.getExtensions());
    }

    public Class<BitstreamFormatRest> getDomainClass() {
        return BitstreamFormatRest.class;
    }
}

