/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.Collection;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.collection.logo")
public class CollectionLogoLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    CollectionService collectionService;

    @PreAuthorize(value="hasPermission(#collectionId, 'COLLECTION', 'READ')")
    public BitstreamRest getLogo(@Nullable HttpServletRequest request, UUID collectionId, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            Context context = this.obtainContext();
            Collection collection = (Collection)this.collectionService.find(context, collectionId);
            if (collection == null) {
                throw new ResourceNotFoundException("No such collection: " + collectionId);
            }
            if (collection.getLogo() == null) {
                return null;
            }
            return (BitstreamRest)this.converter.toRest((Object)collection.getLogo(), projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

