/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.exception;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.rest.exception.MethodNotAllowedException;
import org.dspace.app.rest.exception.MissingParameterException;
import org.dspace.app.rest.exception.RESTAuthorizationException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.security.RestAuthenticationService;
import org.dspace.authorize.AuthorizeException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.repository.support.QueryMethodParameterConversionException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class DSpaceApiExceptionControllerAdvice
extends ResponseEntityExceptionHandler {
    @Autowired
    private RestAuthenticationService restAuthenticationService;

    @ExceptionHandler(value={AuthorizeException.class, RESTAuthorizationException.class, AccessDeniedException.class})
    protected void handleAuthorizeException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        if (this.restAuthenticationService.hasAuthenticationData(request)) {
            this.sendErrorResponse(request, response, ex, ex.getMessage(), 403);
        } else {
            this.sendErrorResponse(request, response, ex, ex.getMessage(), 401);
        }
    }

    @ExceptionHandler(value={IllegalArgumentException.class, MultipartException.class})
    protected void handleWrongRequestException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        this.sendErrorResponse(request, response, ex, ex.getMessage(), 400);
    }

    @ExceptionHandler(value={SQLException.class})
    protected void handleSQLException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        this.sendErrorResponse(request, response, ex, "An internal database error occurred", 500);
    }

    @ExceptionHandler(value={IOException.class})
    protected void handleIOException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        this.sendErrorResponse(request, response, ex, "An internal read or write operation failed (IO Exception)", 500);
    }

    @ExceptionHandler(value={MethodNotAllowedException.class})
    protected void methodNotAllowedException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        this.sendErrorResponse(request, response, ex, ex.getMessage(), 405);
    }

    @ExceptionHandler(value={UnprocessableEntityException.class})
    protected void handleUnprocessableEntityException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        this.sendErrorResponse(request, response, null, ex.getMessage(), HttpStatus.UNPROCESSABLE_ENTITY.value());
    }

    @ExceptionHandler(value={QueryMethodParameterConversionException.class})
    protected void ParameterConversionException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        this.sendErrorResponse(request, response, null, ex.getMessage(), HttpStatus.BAD_REQUEST.value());
    }

    @ExceptionHandler(value={MissingParameterException.class})
    protected void MissingParameterException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        this.sendErrorResponse(request, response, null, ex.getMessage(), HttpStatus.BAD_REQUEST.value());
    }

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        return super.handleMissingServletRequestParameter(ex, headers, HttpStatus.BAD_REQUEST, request);
    }

    protected ResponseEntity<Object> handleTypeMismatch(TypeMismatchException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        return super.handleTypeMismatch(ex, headers, HttpStatus.BAD_REQUEST, request);
    }

    @ExceptionHandler(value={Exception.class})
    protected void handleGenericException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        ResponseStatus responseStatusAnnotation = (ResponseStatus)AnnotationUtils.findAnnotation(ex.getClass(), ResponseStatus.class);
        int returnCode = 0;
        returnCode = responseStatusAnnotation != null ? responseStatusAnnotation.code().value() : 500;
        this.sendErrorResponse(request, response, ex, "An Exception has occured", returnCode);
    }

    private void sendErrorResponse(HttpServletRequest request, HttpServletResponse response, Exception ex, String message, int statusCode) throws IOException {
        request.setAttribute(DispatcherServlet.EXCEPTION_ATTRIBUTE, (Object)ex);
        response.sendError(statusCode, message);
    }
}

