/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.model.AuthorityEntryRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.app.rest.utils.AuthorityUtils;
import org.dspace.content.Collection;
import org.dspace.content.authority.Choice;
import org.dspace.content.authority.Choices;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="integration.authority.entries")
public class AuthorityEntryLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private ChoiceAuthorityService cas;
    @Autowired
    private CollectionService cs;
    @Autowired
    private AuthorityUtils authorityUtils;

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<AuthorityEntryRest> query(@Nullable HttpServletRequest request, String name, @Nullable Pageable optionalPageable, Projection projection) {
        Context context = this.obtainContext();
        String query = request == null ? null : request.getParameter("query");
        String metadata = request == null ? null : request.getParameter("metadata");
        String uuidCollect\u00econ = request == null ? null : request.getParameter("uuid");
        Collection collection = null;
        if (StringUtils.isNotBlank((CharSequence)uuidCollect\u00econ)) {
            try {
                collection = (Collection)this.cs.find(context, UUID.fromString(uuidCollect\u00econ));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        ArrayList<AuthorityEntryRest> results = new ArrayList<AuthorityEntryRest>();
        Pageable pageable = this.utils.getPageable(optionalPageable);
        if (StringUtils.isNotBlank((CharSequence)metadata)) {
            String[] tokens = Utils.tokenize((String)metadata);
            String fieldKey = Utils.standardize((String)tokens[0], (String)tokens[1], (String)tokens[2], (String)"_");
            Choices choices = this.cas.getMatches(fieldKey, query, collection, Math.toIntExact(pageable.getOffset()), pageable.getPageSize(), context.getCurrentLocale().toString());
            for (Choice value : choices.values) {
                results.add(this.authorityUtils.convertEntry(value, name, projection));
            }
        }
        return new PageImpl(results, pageable, (long)results.size());
    }
}

