/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.AuthorityEntryRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.app.rest.utils.AuthorityUtils;
import org.dspace.content.authority.Choice;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="integration.authority.entryValues")
public class AuthorityEntryValueLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private ChoiceAuthorityService cas;
    @Autowired
    private AuthorityUtils authorityUtils;

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public AuthorityEntryRest getResource(HttpServletRequest request, String name, String relId, Pageable pageable, Projection projection) {
        Context context = this.obtainContext();
        ChoiceAuthority choiceAuthority = this.cas.getChoiceAuthorityByAuthorityName(name);
        Choice choice = choiceAuthority.getChoice(null, relId, context.getCurrentLocale().toString());
        if (choice == null) {
            throw new ResourceNotFoundException("The authority was not found");
        }
        return this.authorityUtils.convertEntry(choice, name, projection);
    }

    public boolean isEmbeddableRelation(Object data, String name) {
        return false;
    }
}

