/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.converter.BrowseEntryConverter;
import org.dspace.app.rest.model.BrowseEntryRest;
import org.dspace.app.rest.model.BrowseIndexRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.app.rest.utils.ScopeResolver;
import org.dspace.browse.BrowseEngine;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.BrowseInfo;
import org.dspace.browse.BrowserScope;
import org.dspace.core.Context;
import org.dspace.discovery.IndexableObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;

@Component(value="discover.browse.entries")
public class BrowseEntryLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    BrowseEntryConverter browseEntryConverter;
    @Autowired
    ScopeResolver scopeResolver;

    public Page<BrowseEntryRest> listBrowseEntries(HttpServletRequest request, String browseName, Pageable pageable, Projection projection) throws BrowseException, SQLException {
        String scope = null;
        String startsWith = null;
        if (request != null) {
            scope = request.getParameter("scope");
            startsWith = request.getParameter("startsWith");
        }
        Context context = this.obtainContext();
        BrowseEngine be = new BrowseEngine(context);
        BrowserScope bs = new BrowserScope(context);
        IndexableObject scopeObj = this.scopeResolver.resolveScope(context, scope);
        BrowseIndex bi = StringUtils.isNotEmpty((CharSequence)browseName) ? BrowseIndex.getBrowseIndex((String)browseName) : null;
        if (bi == null) {
            throw new IllegalArgumentException("Unknown browse index");
        }
        if (!bi.isMetadataIndex()) {
            throw new IllegalStateException("The requested browse haven't metadata entries");
        }
        bs.setBrowseIndex(bi);
        Sort sort = null;
        if (pageable != null) {
            sort = pageable.getSort();
        }
        if (sort != null) {
            Iterator orders = sort.iterator();
            while (orders.hasNext()) {
                bs.setOrder(((Sort.Order)orders.next()).getDirection().name());
            }
        }
        bs.setStartsWith(startsWith);
        if (pageable != null) {
            bs.setOffset(Math.toIntExact(pageable.getOffset()));
            bs.setResultsPerPage(pageable.getPageSize());
        }
        if (scopeObj != null) {
            bs.setBrowseContainer(scopeObj);
        }
        BrowseInfo binfo = be.browse(bs);
        PageRequest pageResultInfo = PageRequest.of((int)((binfo.getStart() - 1) / binfo.getResultsPerPage()), (int)binfo.getResultsPerPage());
        Page page = new PageImpl(Arrays.asList(binfo.getStringResults()), (Pageable)pageResultInfo, (long)binfo.getTotal()).map((Function)this.browseEntryConverter);
        BrowseIndexRest biRest = (BrowseIndexRest)this.converter.toRest((Object)bi, projection);
        page.forEach(t -> t.setBrowseIndex(biRest));
        return page;
    }

    public boolean isEmbeddableRelation(Object data, String name) {
        BrowseIndexRest bir = (BrowseIndexRest)data;
        return bir.isMetadataBrowse() && "entries".equals(name);
    }
}

