/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.authorization.AuthorizeServiceRestUtil;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.BundleRest;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canReorderBitstreams", description="It can be used to verify if bitstreams can be reordered in a specific bundle")
public class ReorderBitstreamFeature
implements AuthorizationFeature {
    public static final String NAME = "canReorderBitstreams";
    @Autowired
    private AuthorizeServiceRestUtil authorizeServiceRestUtil;

    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        if (object instanceof BundleRest) {
            return this.authorizeServiceRestUtil.authorizeActionBoolean(context, object, DSpaceRestPermission.WRITE);
        }
        return false;
    }

    public String[] getSupportedTypes() {
        return new String[]{"core.bundle"};
    }
}

