/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.io.Serializable;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.model.DSpaceObjectRest;
import org.dspace.app.rest.model.EPersonRest;
import org.dspace.app.rest.model.GroupRest;
import org.dspace.app.rest.model.ResourcePolicyRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.ResourcePolicyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResourcePolicyConverter
implements DSpaceConverter<ResourcePolicy, ResourcePolicyRest> {
    @Autowired
    ResourcePolicyService resourcePolicyService;
    @Autowired
    ConverterService converterService;

    public ResourcePolicyRest convert(ResourcePolicy obj, Projection projection) {
        ResourcePolicyRest model = new ResourcePolicyRest();
        model.setProjection(projection);
        model.setId((Serializable)obj.getID());
        model.setName(obj.getRpName());
        model.setDescription(obj.getRpDescription());
        model.setPolicyType(obj.getRpType());
        model.setAction(this.resourcePolicyService.getActionText(obj));
        model.setStartDate(obj.getStartDate());
        model.setEndDate(obj.getEndDate());
        if (obj.getGroup() != null) {
            model.setGroup((GroupRest)this.converterService.toRest((Object)obj.getGroup(), projection));
        }
        if (obj.getEPerson() != null) {
            model.setEperson((EPersonRest)this.converterService.toRest((Object)obj.getEPerson(), projection));
        }
        if (obj.getdSpaceObject() != null) {
            model.setResource((DSpaceObjectRest)this.converterService.toRest((Object)obj.getdSpaceObject(), projection));
        }
        return model;
    }

    public Class<ResourcePolicy> getModelClass() {
        return ResourcePolicy.class;
    }
}

