/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.converter.SubmissionSectionConverter;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.SubmissionDefinitionRest;
import org.dspace.app.rest.model.SubmissionSectionRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.util.SubmissionConfig;
import org.dspace.app.util.SubmissionConfigReaderException;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.content.Collection;
import org.dspace.core.Context;
import org.dspace.services.RequestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SubmissionDefinitionConverter
implements DSpaceConverter<SubmissionConfig, SubmissionDefinitionRest> {
    private static final Logger log = LogManager.getLogger(SubmissionDefinitionConverter.class);
    @Autowired
    private SubmissionSectionConverter panelConverter;
    @Autowired
    private RequestService requestService;
    @Autowired
    private ConverterService converter;

    public SubmissionDefinitionRest convert(SubmissionConfig obj, Projection projection) {
        SubmissionDefinitionRest sd = new SubmissionDefinitionRest();
        sd.setProjection(projection);
        sd.setName(obj.getSubmissionName());
        sd.setDefaultConf(obj.isDefaultConf());
        LinkedList<SubmissionSectionRest> panels = new LinkedList<SubmissionSectionRest>();
        for (int idx = 0; idx < obj.getNumberOfSteps(); ++idx) {
            SubmissionStepConfig step = obj.getStep(idx);
            SubmissionSectionRest sp = (SubmissionSectionRest)this.converter.toRest((Object)step, projection);
            panels.add(sp);
        }
        HttpServletRequest request = this.requestService.getCurrentRequest().getHttpServletRequest();
        Context context = null;
        try {
            context = ContextUtil.obtainContext((ServletRequest)request);
            List collections = this.panelConverter.getSubmissionConfigReader().getCollectionsBySubmissionConfig(context, obj.getSubmissionName());
            DSpaceConverter cc = this.converter.getConverter(Collection.class);
            List collectionsRest = collections.stream().map(collection -> (CollectionRest)cc.convert(collection, projection)).collect(Collectors.toList());
            sd.setCollections(collectionsRest);
        }
        catch (IllegalStateException | SQLException | SubmissionConfigReaderException e) {
            log.error(e.getMessage(), e);
        }
        sd.setPanels(panels);
        return sd;
    }

    public Class<SubmissionConfig> getModelClass() {
        return SubmissionConfig.class;
    }
}

