/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.rest.DiscoverableEndpointsService;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.exception.RESTAuthorizationException;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.ClaimedTaskRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.dspace.workflow.WorkflowException;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.service.WorkflowRequirementsService;
import org.dspace.xmlworkflow.service.XmlWorkflowService;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.Workflow;
import org.dspace.xmlworkflow.state.actions.Action;
import org.dspace.xmlworkflow.state.actions.WorkflowActionConfig;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.ClaimedTaskService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.hateoas.Link;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="workflow.claimedtask")
public class ClaimedTaskRestRepository
extends DSpaceRestRepository<ClaimedTaskRest, Integer>
implements InitializingBean {
    private static final Logger log = Logger.getLogger(ClaimedTaskRestRepository.class);
    @Autowired
    ItemService itemService;
    @Autowired
    EPersonService epersonService;
    @Autowired
    ClaimedTaskService claimedTaskService;
    @Autowired
    XmlWorkflowService workflowService;
    @Autowired
    WorkflowRequirementsService workflowRequirementsService;
    @Autowired
    AuthorizeService authorizeService;
    @Autowired
    DiscoverableEndpointsService discoverableEndpointsService;

    @PreAuthorize(value="hasPermission(#id, 'CLAIMEDTASK', 'READ')")
    public ClaimedTaskRest findOne(Context context, Integer id) {
        ClaimedTask task = null;
        try {
            task = (ClaimedTask)this.claimedTaskService.find(context, id.intValue());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (task == null) {
            return null;
        }
        return (ClaimedTaskRest)this.converter.toRest((Object)task, this.utils.obtainProjection());
    }

    @SearchRestMethod(name="findByUser")
    public Page<ClaimedTaskRest> findByUser(@Parameter(value="uuid", required=true) UUID userID, Pageable pageable) {
        try {
            Context context = this.obtainContext();
            EPerson currentUser = context.getCurrentUser();
            if (currentUser == null) {
                throw new RESTAuthorizationException("This endpoint is available only to logged-in user to search for their own claimed tasks or the admins");
            }
            if (this.authorizeService.isAdmin(context) || userID.equals(currentUser.getID())) {
                EPerson ep = (EPerson)this.epersonService.find(context, userID);
                List tasks = this.claimedTaskService.findByEperson(context, ep);
                return this.converter.toRestPage(tasks, pageable, this.utils.obtainProjection());
            }
            throw new RESTAuthorizationException("Only administrators can search for claimed tasks of other users");
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Class<ClaimedTaskRest> getDomainClass() {
        return ClaimedTaskRest.class;
    }

    @PreAuthorize(value="hasPermission(#id, 'CLAIMEDTASK', 'WRITE')")
    protected ClaimedTaskRest action(Context context, HttpServletRequest request, Integer id) throws SQLException, IOException {
        ClaimedTask task = null;
        task = (ClaimedTask)this.claimedTaskService.find(context, id.intValue());
        if (task == null) {
            throw new ResourceNotFoundException("ClaimedTask ID " + id + " not found");
        }
        XmlWorkflowServiceFactory factory = XmlWorkflowServiceFactory.getInstance();
        try {
            Workflow workflow = factory.getWorkflowFactory().getWorkflow(task.getWorkflowItem().getCollection());
            Step step = workflow.getStep(task.getStepID());
            WorkflowActionConfig currentActionConfig = step.getActionConfig(task.getActionID());
            String submitButton = Util.getSubmitButton((HttpServletRequest)request, null);
            if (!currentActionConfig.getProcessingAction().getOptions().contains(submitButton)) {
                throw new UnprocessableEntityException(submitButton + " is not a valid option on this action (" + currentActionConfig.getProcessingAction().getClass() + ").");
            }
            this.workflowService.doState(context, context.getCurrentUser(), request, task.getWorkflowItem().getID().intValue(), workflow, currentActionConfig);
            if (!Action.getErrorFields((HttpServletRequest)request).isEmpty()) {
                throw new UnprocessableEntityException("Missing required fields: " + StringUtils.join((Iterable)Action.getErrorFields((HttpServletRequest)request), (String)","));
            }
        }
        catch (AuthorizeException e) {
            throw new RESTAuthorizationException(e);
        }
        catch (WorkflowException e) {
            throw new UnprocessableEntityException("Invalid workflow action: " + e.getMessage(), (Throwable)e);
        }
        catch (MessagingException | WorkflowConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return null;
    }

    @PreAuthorize(value="hasPermission(#id, 'CLAIMEDTASK', 'DELETE')")
    protected void delete(Context context, Integer id) {
        ClaimedTask task = null;
        try {
            task = (ClaimedTask)this.claimedTaskService.find(context, id.intValue());
            if (task == null) {
                throw new ResourceNotFoundException("ClaimedTask ID " + id + " not found");
            }
            XmlWorkflowItem workflowItem = task.getWorkflowItem();
            this.workflowService.deleteClaimedTask(context, workflowItem, task);
            this.workflowRequirementsService.removeClaimedUser(context, workflowItem, task.getOwner(), task.getStepID());
        }
        catch (AuthorizeException e) {
            throw new RESTAuthorizationException(e);
        }
        catch (IOException | SQLException | WorkflowConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Page<ClaimedTaskRest> findAll(Context context, Pageable pageable) {
        throw new RepositoryMethodNotImplementedException("claimedtask", "findAll");
    }

    public void afterPropertiesSet() throws Exception {
        this.discoverableEndpointsService.register((Object)this, Arrays.asList(new Link("/api/workflow/claimedtask/search", "claimedtask-search")));
    }
}

