/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.item.mappedCollections")
public class ItemMappedCollectionLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    ItemService itemService;

    @PreAuthorize(value="hasPermission(#itemId, 'ITEM', 'READ')")
    public Page<CollectionRest> getMappedCollections(@Nullable HttpServletRequest request, UUID itemId, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            Context context = this.obtainContext();
            Item item = (Item)this.itemService.find(context, itemId);
            if (item == null) {
                throw new ResourceNotFoundException("No such item: " + itemId);
            }
            UUID owningCollectionId = item.getOwningCollection() == null ? null : item.getOwningCollection().getID();
            List collections = item.getCollections().stream().filter(collection -> !collection.getID().equals(owningCollectionId)).collect(Collectors.toList());
            return this.converter.toRestPage(collections, optionalPageable, projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

