/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation;

import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.springframework.stereotype.Component;

@Component
public class ItemDiscoverableReplaceOperation<R>
extends PatchOperation<R> {
    private static final String OPERATION_PATH_DISCOVERABLE = "/discoverable";

    public R perform(Context context, R object, Operation operation) {
        this.checkOperationValue(operation.getValue());
        Boolean discoverable = this.getBooleanOperationValue(operation.getValue());
        if (this.supports(object, operation)) {
            Item item = (Item)object;
            if (discoverable.booleanValue() && item.getTemplateItemOf() != null) {
                throw new UnprocessableEntityException("A template item cannot be discoverable.");
            }
            item.setDiscoverable(discoverable.booleanValue());
            return object;
        }
        throw new DSpaceBadRequestException("ItemDiscoverableReplaceOperation does not support this operation");
    }

    public boolean supports(Object objectToMatch, Operation operation) {
        return objectToMatch instanceof Item && operation.getOp().trim().equalsIgnoreCase("replace") && operation.getPath().trim().equalsIgnoreCase(OPERATION_PATH_DISCOVERABLE);
    }
}

