/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.security.RestObjectPermissionEvaluatorPlugin;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class EPersonRestPermissionEvaluatorPlugin
extends RestObjectPermissionEvaluatorPlugin {
    private static final Logger log = LoggerFactory.getLogger(EPersonRestPermissionEvaluatorPlugin.class);
    @Autowired
    AuthorizeService authorizeService;
    @Autowired
    private RequestService requestService;

    public boolean hasDSpacePermission(Authentication authentication, Serializable targetId, String targetType, DSpaceRestPermission permission) {
        DSpaceRestPermission restPermission = DSpaceRestPermission.convert((Object)permission);
        if (!(DSpaceRestPermission.READ.equals((Object)restPermission) || DSpaceRestPermission.WRITE.equals((Object)restPermission) || DSpaceRestPermission.DELETE.equals((Object)restPermission))) {
            return false;
        }
        if (Constants.getTypeID((String)targetType) != 7) {
            return false;
        }
        Request request = this.requestService.getCurrentRequest();
        Context context = ContextUtil.obtainContext((ServletRequest)request.getServletRequest());
        EPerson ePerson = null;
        ePerson = context.getCurrentUser();
        UUID dsoId = UUID.fromString(targetId.toString());
        try {
            if (ePerson == null) {
                return false;
            }
            if (dsoId.equals(ePerson.getID())) {
                return true;
            }
            if (this.authorizeService.isCommunityAdmin(context, ePerson) && AuthorizeUtil.canCommunityAdminManageAccounts()) {
                return true;
            }
            if (this.authorizeService.isCollectionAdmin(context, ePerson) && AuthorizeUtil.canCollectionAdminManageAccounts()) {
                return true;
            }
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public boolean hasPatchPermission(Authentication authentication, Serializable targetId, String targetType, Patch patch) {
        List operations = patch.getOperations();
        Request currentRequest = this.requestService.getCurrentRequest();
        if (currentRequest != null) {
            HttpServletRequest httpServletRequest = currentRequest.getHttpServletRequest();
            if (operations.size() > 0 && StringUtils.equalsIgnoreCase((CharSequence)((Operation)operations.get(0)).getOp(), (CharSequence)"replace") && StringUtils.equalsIgnoreCase((CharSequence)((Operation)operations.get(0)).getPath(), (CharSequence)"/password") && StringUtils.isNotBlank((CharSequence)httpServletRequest.getParameter("token"))) {
                return true;
            }
        }
        if (!this.hasPermission(authentication, targetId, targetType, (Object)"WRITE")) {
            return false;
        }
        for (Operation op : operations) {
            if (op.getPath().contentEquals("/password") || op.getPath().startsWith("/metadata")) continue;
            return false;
        }
        return true;
    }
}

