/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canManageMappedItems", description="It can be used to verify if mapped items can be listed, searched, added and removed")
public class ManageMappedItemsFeature
implements AuthorizationFeature {
    public static final String NAME = "canManageMappedItems";
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private Utils utils;

    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        Collection collection;
        return object instanceof CollectionRest && this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)(collection = (Collection)this.utils.getDSpaceAPIObjectFromRest(context, object)), 1) && this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)collection, 3);
    }

    public String[] getSupportedTypes() {
        return new String[]{"core.collection"};
    }
}

