/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.MetadataConverter;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.BundleRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.DSpaceObjectRestRepository;
import org.dspace.app.rest.repository.handler.service.UriListHandlerService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.util.UUIDUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.item")
public class ItemRestRepository
extends DSpaceObjectRestRepository<Item, ItemRest> {
    private static final Logger log = LogManager.getLogger(ItemRestRepository.class);
    public static final String[] COPYVIRTUAL_ALL = new String[]{"all"};
    public static final String[] COPYVIRTUAL_CONFIGURED = new String[]{"configured"};
    public static final String REQUESTPARAMETER_COPYVIRTUALMETADATA = "copyVirtualMetadata";
    @Autowired
    MetadataConverter metadataConverter;
    @Autowired
    BundleService bundleService;
    @Autowired
    WorkspaceItemService workspaceItemService;
    @Autowired
    ItemService itemService;
    @Autowired
    CollectionService collectionService;
    @Autowired
    InstallItemService installItemService;
    @Autowired
    RelationshipService relationshipService;
    @Autowired
    RelationshipTypeService relationshipTypeService;
    @Autowired
    private UriListHandlerService uriListHandlerService;

    public ItemRestRepository(ItemService dsoService) {
        super((DSpaceObjectService)dsoService);
    }

    @PreAuthorize(value="hasPermission(#id, 'ITEM', 'READ')")
    public ItemRest findOne(Context context, UUID id) {
        Item item = null;
        try {
            item = (Item)this.itemService.find(context, id);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (item == null) {
            return null;
        }
        if (item.getTemplateItemOf() != null) {
            throw new DSpaceBadRequestException("Item with id: " + id + " is a template item.");
        }
        return (ItemRest)this.converter.toRest((Object)item, this.utils.obtainProjection());
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    public Page<ItemRest> findAll(Context context, Pageable pageable) {
        try {
            long total = this.itemService.countTotal(context);
            Iterator it = this.itemService.findAll(context, Integer.valueOf(pageable.getPageSize()), Integer.valueOf(Math.toIntExact(pageable.getOffset())));
            ArrayList<Item> items = new ArrayList<Item>();
            while (it.hasNext()) {
                items.add((Item)it.next());
            }
            return this.converter.toRestPage(items, pageable, total, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @PreAuthorize(value="hasPermission(#id, 'ITEM', #patch)")
    protected void patch(Context context, HttpServletRequest request, String apiCategory, String model, UUID id, Patch patch) throws AuthorizeException, SQLException {
        this.patchDSpaceObject(apiCategory, model, id, patch);
    }

    public Class<ItemRest> getDomainClass() {
        return ItemRest.class;
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected void delete(Context context, UUID id) throws AuthorizeException {
        String[] copyVirtual = this.requestService.getCurrentRequest().getServletRequest().getParameterValues(REQUESTPARAMETER_COPYVIRTUALMETADATA);
        Item item = null;
        try {
            item = (Item)this.itemService.find(context, id);
            if (item == null) {
                throw new ResourceNotFoundException("core.item with id: " + id + " not found");
            }
            if (this.itemService.isInProgressSubmission(context, item)) {
                throw new UnprocessableEntityException("The item cannot be deleted. It's part of a in-progress submission.");
            }
            if (item.getTemplateItemOf() != null) {
                throw new UnprocessableEntityException("The item cannot be deleted. It's a template for a collection");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            this.deleteMultipleRelationshipsCopyVirtualMetadata(context, copyVirtual, item);
            this.itemService.delete(context, (DSpaceObject)item);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void deleteMultipleRelationshipsCopyVirtualMetadata(Context context, String[] copyVirtual, Item item) throws SQLException, AuthorizeException {
        if (copyVirtual == null || copyVirtual.length == 0) {
            return;
        }
        if (Objects.deepEquals(copyVirtual, COPYVIRTUAL_ALL)) {
            for (Relationship relationship : this.relationshipService.findByItem(context, item)) {
                this.deleteRelationshipCopyVirtualMetadata(item, relationship);
            }
        } else if (Objects.deepEquals(copyVirtual, COPYVIRTUAL_CONFIGURED)) {
            for (Relationship relationship : this.relationshipService.findByItem(context, item)) {
                boolean copyToLeft = relationship.getRelationshipType().isCopyToLeft();
                boolean copyToRight = relationship.getRelationshipType().isCopyToRight();
                if (relationship.getLeftItem().getID().equals(item.getID())) {
                    copyToLeft = false;
                } else {
                    copyToRight = false;
                }
                this.relationshipService.forceDelete(this.obtainContext(), relationship, copyToLeft, copyToRight);
            }
        } else {
            List relationshipIds = this.parseVirtualMetadataTypes(copyVirtual);
            for (Integer relationshipId : relationshipIds) {
                RelationshipType relationshipType = (RelationshipType)this.relationshipTypeService.find(context, relationshipId.intValue());
                for (Relationship relationship : this.relationshipService.findByItemAndRelationshipType(context, item, relationshipType)) {
                    this.deleteRelationshipCopyVirtualMetadata(item, relationship);
                }
            }
        }
    }

    private List<Integer> parseVirtualMetadataTypes(String[] copyVirtual) {
        ArrayList<Integer> types = new ArrayList<Integer>();
        for (String typeString : copyVirtual) {
            if (!StringUtils.isNumeric((CharSequence)typeString)) {
                throw new DSpaceBadRequestException("parameter copyVirtualMetadata should only contain a single value '" + COPYVIRTUAL_ALL[0] + "', '" + COPYVIRTUAL_CONFIGURED[0] + "' or a list of numbers.");
            }
            types.add(Integer.parseInt(typeString));
        }
        return types;
    }

    private void deleteRelationshipCopyVirtualMetadata(Item itemToDelete, Relationship relationshipToDelete) throws SQLException, AuthorizeException {
        boolean copyToLeft = relationshipToDelete.getRightItem().equals((Object)itemToDelete);
        boolean copyToRight = relationshipToDelete.getLeftItem().equals((Object)itemToDelete);
        if (copyToLeft && copyToRight) {
            copyToLeft = false;
            copyToRight = false;
        }
        this.relationshipService.forceDelete(this.obtainContext(), relationshipToDelete, copyToLeft, copyToRight);
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected ItemRest createAndReturn(Context context) throws AuthorizeException, SQLException {
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        String owningCollectionUuidString = req.getParameter("owningCollection");
        ObjectMapper mapper = new ObjectMapper();
        ItemRest itemRest = null;
        try {
            ServletInputStream input = req.getInputStream();
            itemRest = (ItemRest)mapper.readValue((InputStream)input, ItemRest.class);
        }
        catch (IOException e1) {
            throw new UnprocessableEntityException("Error parsing request body", (Throwable)e1);
        }
        if (!itemRest.getInArchive()) {
            throw new DSpaceBadRequestException("InArchive attribute should not be set to false for the create");
        }
        UUID owningCollectionUuid = UUIDUtils.fromString((String)owningCollectionUuidString);
        Collection collection = (Collection)this.collectionService.find(context, owningCollectionUuid);
        if (collection == null) {
            throw new DSpaceBadRequestException("The given owningCollection parameter is invalid: " + owningCollectionUuid);
        }
        WorkspaceItem workspaceItem = this.workspaceItemService.create(context, collection, false);
        Item item = workspaceItem.getItem();
        item.setArchived(true);
        item.setOwningCollection(collection);
        item.setDiscoverable(itemRest.getDiscoverable());
        item.setLastModified(itemRest.getLastModified());
        this.metadataConverter.setMetadata(context, (DSpaceObject)item, itemRest.getMetadata());
        Item itemToReturn = this.installItemService.installItem(context, (InProgressSubmission)workspaceItem);
        return (ItemRest)this.converter.toRest((Object)itemToReturn, this.utils.obtainProjection());
    }

    @PreAuthorize(value="hasPermission(#uuid, 'ITEM', 'WRITE')")
    protected ItemRest put(Context context, HttpServletRequest request, String apiCategory, String model, UUID uuid, JsonNode jsonNode) throws RepositoryMethodNotImplementedException, SQLException, AuthorizeException {
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        ObjectMapper mapper = new ObjectMapper();
        ItemRest itemRest = null;
        try {
            itemRest = (ItemRest)mapper.readValue(jsonNode.toString(), ItemRest.class);
        }
        catch (IOException e1) {
            throw new UnprocessableEntityException("Error parsing request body", (Throwable)e1);
        }
        Item item = (Item)this.itemService.find(context, uuid);
        if (item == null) {
            throw new ResourceNotFoundException(apiCategory + "." + model + " with id: " + uuid + " not found");
        }
        if (!StringUtils.equals((CharSequence)uuid.toString(), (CharSequence)itemRest.getId())) {
            throw new IllegalArgumentException("The UUID in the Json and the UUID in the url do not match: " + uuid + ", " + itemRest.getId());
        }
        this.metadataConverter.setMetadata(context, (DSpaceObject)item, itemRest.getMetadata());
        return (ItemRest)this.converter.toRest((Object)item, this.utils.obtainProjection());
    }

    public Bundle addBundleToItem(Context context, Item item, BundleRest bundleRest) throws SQLException, AuthorizeException {
        if (item.getBundles(bundleRest.getName()).size() > 0) {
            throw new DSpaceBadRequestException("The bundle name already exists in the item");
        }
        Bundle bundle = this.bundleService.create(context, item, bundleRest.getName());
        this.metadataConverter.setMetadata(context, (DSpaceObject)bundle, bundleRest.getMetadata());
        bundle.setName(context, bundleRest.getName());
        context.commit();
        return bundle;
    }

    protected ItemRest createAndReturn(Context context, List<String> stringList) throws AuthorizeException, SQLException, RepositoryMethodNotImplementedException {
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        Item item = (Item)this.uriListHandlerService.handle(context, req, stringList, Item.class);
        return (ItemRest)this.converter.toRest((Object)item, this.utils.obtainProjection());
    }
}

