/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.converter.MetadataConverter;
import org.dspace.app.rest.exception.GroupNameNotProvidedException;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.GroupRest;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.DSpaceObjectRestRepository;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="eperson.group")
public class GroupRestRepository
extends DSpaceObjectRestRepository<Group, GroupRest> {
    @Autowired
    GroupService gs;
    @Autowired
    MetadataConverter metadataConverter;

    @Autowired
    GroupRestRepository(GroupService dsoService) {
        super((DSpaceObjectService)dsoService);
        this.gs = dsoService;
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected GroupRest createAndReturn(Context context) throws AuthorizeException, RepositoryMethodNotImplementedException {
        Group group;
        GroupRest groupRest;
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        ObjectMapper mapper = new ObjectMapper();
        try {
            groupRest = (GroupRest)mapper.readValue((InputStream)req.getInputStream(), GroupRest.class);
        }
        catch (IOException excIO) {
            throw new UnprocessableEntityException("error parsing the body ..." + excIO.getMessage());
        }
        if (StringUtils.isBlank((CharSequence)groupRest.getName())) {
            throw new GroupNameNotProvidedException();
        }
        try {
            group = this.gs.create(context);
            this.gs.setName(group, groupRest.getName());
            this.gs.update(context, (DSpaceObject)group);
            this.metadataConverter.setMetadata(context, (DSpaceObject)group, groupRest.getMetadata());
        }
        catch (SQLException excSQL) {
            throw new RuntimeException(excSQL.getMessage(), excSQL);
        }
        return (GroupRest)this.converter.toRest((Object)group, this.utils.obtainProjection());
    }

    @PreAuthorize(value="hasPermission(#id, 'GROUP', 'READ')")
    public GroupRest findOne(Context context, UUID id) {
        Group group = null;
        try {
            group = (Group)this.gs.find(context, id);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (group == null) {
            return null;
        }
        return (GroupRest)this.converter.toRest((Object)group, this.utils.obtainProjection());
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    public Page<GroupRest> findAll(Context context, Pageable pageable) {
        try {
            long total = this.gs.countTotal(context);
            List groups = this.gs.findAll(context, null, pageable.getPageSize(), Math.toIntExact(pageable.getOffset()));
            return this.converter.toRestPage(groups, pageable, total, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @PreAuthorize(value="hasPermission(#id, 'GROUP', 'WRITE')")
    protected void patch(Context context, HttpServletRequest request, String apiCategory, String model, UUID id, Patch patch) throws AuthorizeException, SQLException {
        this.patchDSpaceObject(apiCategory, model, id, patch);
    }

    @PreAuthorize(value="hasAuthority('ADMIN') || hasAuthority('MANAGE_ACCESS_GROUP')")
    @SearchRestMethod(name="byMetadata")
    public Page<GroupRest> findByMetadata(@Parameter(value="query", required=true) String query, Pageable pageable) {
        try {
            Context context = this.obtainContext();
            long total = this.gs.searchResultCount(context, query);
            List groups = this.gs.search(context, query, Math.toIntExact(pageable.getOffset()), Math.toIntExact(pageable.getPageSize()));
            return this.converter.toRestPage(groups, pageable, total, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Class<GroupRest> getDomainClass() {
        return GroupRest.class;
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected void delete(Context context, UUID uuid) throws AuthorizeException {
        Group group = null;
        try {
            group = (Group)this.gs.find(context, uuid);
            if (group == null) {
                throw new ResourceNotFoundException("eperson.group with id: " + uuid + " not found");
            }
            try {
                if (group.isPermanent().booleanValue()) {
                    throw new UnprocessableEntityException("A permanent group cannot be deleted");
                }
                DSpaceObject parentObject = this.gs.getParentObject(context, (DSpaceObject)group);
                if (parentObject != null) {
                    throw new UnprocessableEntityException("This group cannot be deleted as it has a parent " + parentObject.getType() + " with id " + parentObject.getID());
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            this.gs.delete(context, (DSpaceObject)group);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

