/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.atteo.evo.inflector.English;
import org.dspace.app.rest.DiscoverableEndpointsService;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.converter.JsonPatchConverter;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.PaginationException;
import org.dspace.app.rest.exception.RESTAuthorizationException;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.exception.RepositoryNotFoundException;
import org.dspace.app.rest.exception.RepositorySearchMethodNotFoundException;
import org.dspace.app.rest.exception.RepositorySearchNotFoundException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.link.HalLinkService;
import org.dspace.app.rest.model.LinkRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.RestModel;
import org.dspace.app.rest.model.hateoas.DSpaceResource;
import org.dspace.app.rest.model.hateoas.EmbeddedPage;
import org.dspace.app.rest.model.hateoas.HALResource;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.app.rest.utils.RestRepositoryUtils;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.util.UUIDUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.util.MultiValueMap;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/{apiCategory}/{model}"})
public class RestResourceController
implements InitializingBean {
    private static final Logger log = LogManager.getLogger(RestResourceController.class);
    @Autowired
    DiscoverableEndpointsService discoverableEndpointsService;
    @Autowired
    Utils utils;
    @Autowired
    RestRepositoryUtils repositoryUtils;
    @Autowired
    private ObjectMapper mapper;
    @Autowired
    HalLinkService linkService;
    @Autowired
    ConverterService converter;

    public void afterPropertiesSet() {
        ArrayList<Link> links = new ArrayList<Link>();
        for (String r : this.utils.getRepositories()) {
            String[] split = r.split("\\.", 2);
            String plural = English.plural((String)split[1]);
            Link l = new Link("/api/" + split[0] + "/" + plural, plural);
            links.add(l);
            log.debug(l.getRel().value() + " " + l.getHref());
        }
        this.discoverableEndpointsService.register((Object)this, links);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id:\\d+}"})
    public HALResource<RestAddressableModel> findOne(@PathVariable String apiCategory, @PathVariable String model, @PathVariable Integer id) {
        return this.findOneInternal(apiCategory, model, (Serializable)id);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id:^(?!^\\d+$)(?!^[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}$)[\\w+\\-\\.:]+$+}"})
    public HALResource<RestAddressableModel> findOne(@PathVariable String apiCategory, @PathVariable String model, @PathVariable String id) {
        return this.findOneInternal(apiCategory, model, (Serializable)((Object)id));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{uuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}"})
    public HALResource<RestAddressableModel> findOne(@PathVariable String apiCategory, @PathVariable String model, @PathVariable UUID uuid) {
        return this.findOneInternal(apiCategory, model, (Serializable)uuid);
    }

    private <ID extends Serializable> HALResource<RestAddressableModel> findOneInternal(String apiCategory, String model, ID id) {
        DSpaceRestRepository repository = this.utils.getResourceRepository(apiCategory, model);
        Optional modelObject = Optional.empty();
        try {
            modelObject = repository.findById(id);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (!modelObject.isPresent()) {
            throw new ResourceNotFoundException(apiCategory + "." + model + " with id: " + id + " not found");
        }
        return this.converter.toResource((RestModel)modelObject.get());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id:\\d+}/{rel}"})
    public RepresentationModel findRel(HttpServletRequest request, HttpServletResponse response, @PathVariable String apiCategory, @PathVariable String model, @PathVariable Integer id, @PathVariable String rel, Pageable page, PagedResourcesAssembler assembler) {
        return this.findRelInternal(request, response, apiCategory, model, (Serializable)id, rel, page, assembler);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id:^(?!^\\d+$)(?!^[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}$)[\\w+\\-\\.:]+$+}/{rel}"})
    public RepresentationModel findRel(HttpServletRequest request, HttpServletResponse response, @PathVariable String apiCategory, @PathVariable String model, @PathVariable String id, @PathVariable String rel, Pageable page, PagedResourcesAssembler assembler) {
        return this.findRelInternal(request, response, apiCategory, model, (Serializable)((Object)id), rel, page, assembler);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{uuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}/{rel}"})
    public RepresentationModel findRel(HttpServletRequest request, HttpServletResponse response, @PathVariable String apiCategory, @PathVariable String model, @PathVariable UUID uuid, @PathVariable String rel, Pageable page, PagedResourcesAssembler assembler) {
        return this.findRelInternal(request, response, apiCategory, model, (Serializable)uuid, rel, page, assembler);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id:^(?!^\\d+$)(?!^[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}$)[\\w+\\-\\.:]+$+}/{rel}/{relid}"})
    public RepresentationModel findRel(HttpServletRequest request, HttpServletResponse response, @PathVariable String apiCategory, @PathVariable String model, @PathVariable String id, @PathVariable String rel, @PathVariable String relid, Pageable page, PagedResourcesAssembler assembler) throws Throwable {
        return this.findRelEntryInternal(request, response, apiCategory, model, id, rel, relid, page, assembler);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id:\\d+}/{rel}/{relid}"})
    public RepresentationModel findRel(HttpServletRequest request, HttpServletResponse response, @PathVariable String apiCategory, @PathVariable String model, @PathVariable Integer id, @PathVariable String rel, @PathVariable String relid, Pageable page, PagedResourcesAssembler assembler) throws Throwable {
        return this.findRelEntryInternal(request, response, apiCategory, model, id.toString(), rel, relid, page, assembler);
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json", "application/hal+json"})
    public ResponseEntity<RepresentationModel<?>> post(HttpServletRequest request, @PathVariable String apiCategory, @PathVariable String model, @RequestParam(required=false) String parent) throws HttpRequestMethodNotSupportedException {
        return this.postJsonInternal(request, apiCategory, model, parent);
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"text/uri-list"})
    public ResponseEntity<RepresentationModel<?>> postWithUriListContentType(HttpServletRequest request, @PathVariable String apiCategory, @PathVariable String model) throws HttpRequestMethodNotSupportedException {
        return this.postUriListInternal(request, apiCategory, model);
    }

    public <ID extends Serializable> ResponseEntity<RepresentationModel<?>> postJsonInternal(HttpServletRequest request, String apiCategory, String model, String parent) throws HttpRequestMethodNotSupportedException {
        RestAddressableModel modelObject;
        this.checkModelPluralForm(apiCategory, model);
        DSpaceRestRepository repository = this.utils.getResourceRepository(apiCategory, model);
        if (parent != null) {
            UUID parentUuid = UUIDUtils.fromString((String)parent);
            modelObject = repository.createAndReturn(parentUuid);
        } else {
            modelObject = repository.createAndReturn();
        }
        if (modelObject == null) {
            return ControllerUtils.toEmptyResponse((HttpStatus)HttpStatus.CREATED);
        }
        DSpaceResource result = (DSpaceResource)this.converter.toResource((RestModel)modelObject);
        return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.CREATED, (HttpHeaders)new HttpHeaders(), (RepresentationModel)result);
    }

    public <ID extends Serializable> ResponseEntity<RepresentationModel<?>> postUriListInternal(HttpServletRequest request, String apiCategory, String model) throws HttpRequestMethodNotSupportedException {
        this.checkModelPluralForm(apiCategory, model);
        DSpaceRestRepository repository = this.utils.getResourceRepository(apiCategory, model);
        RestAddressableModel modelObject = null;
        List stringListFromRequest = this.utils.getStringListFromRequest(request);
        try {
            modelObject = repository.createAndReturn(stringListFromRequest);
        }
        catch (ClassCastException e) {
            log.error("Something went wrong whilst creating the object for apiCategory: " + apiCategory + " and model: " + model, (Throwable)e);
            return ControllerUtils.toEmptyResponse((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        if (modelObject == null) {
            return ControllerUtils.toEmptyResponse((HttpStatus)HttpStatus.CREATED);
        }
        DSpaceResource result = (DSpaceResource)this.converter.toResource((RestModel)modelObject);
        return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.CREATED, (HttpHeaders)new HttpHeaders(), (RepresentationModel)result);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{id:\\d+}"}, headers={"content-type=application/x-www-form-urlencoded"})
    public ResponseEntity<RepresentationModel<?>> action(HttpServletRequest request, @PathVariable String apiCategory, @PathVariable String model, @PathVariable Integer id) throws HttpRequestMethodNotSupportedException, SQLException, IOException {
        this.checkModelPluralForm(apiCategory, model);
        DSpaceRestRepository repository = this.utils.getResourceRepository(apiCategory, model);
        RestAddressableModel modelObject = null;
        try {
            modelObject = repository.action(request, (Serializable)id);
        }
        catch (UnprocessableEntityException e) {
            log.error(e.getMessage(), (Throwable)e);
            return ControllerUtils.toEmptyResponse((HttpStatus)HttpStatus.UNPROCESSABLE_ENTITY);
        }
        if (modelObject != null) {
            DSpaceResource result = (DSpaceResource)this.converter.toResource((RestModel)modelObject);
            return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.CREATED, (HttpHeaders)new HttpHeaders(), (RepresentationModel)result);
        }
        return ControllerUtils.toEmptyResponse((HttpStatus)HttpStatus.NO_CONTENT);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{id:\\d+}"}, headers={"content-type=multipart/form-data"})
    public <ID extends Serializable> ResponseEntity<RepresentationModel<?>> upload(HttpServletRequest request, @PathVariable String apiCategory, @PathVariable String model, @PathVariable Integer id, @RequestParam(value="file") MultipartFile uploadfile) throws HttpRequestMethodNotSupportedException {
        return this.uploadInternal(request, apiCategory, model, (Serializable)id, uploadfile);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{uuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}"}, headers={"content-type=multipart/form-data"})
    public <ID extends Serializable> ResponseEntity<RepresentationModel<?>> upload(HttpServletRequest request, @PathVariable String apiCategory, @PathVariable String model, @PathVariable UUID uuid, @RequestParam(value="file") MultipartFile uploadfile) throws HttpRequestMethodNotSupportedException {
        return this.uploadInternal(request, apiCategory, model, (Serializable)uuid, uploadfile);
    }

    private <ID extends Serializable> ResponseEntity<RepresentationModel<?>> uploadInternal(HttpServletRequest request, String apiCategory, String model, ID id, MultipartFile uploadfile) {
        this.checkModelPluralForm(apiCategory, model);
        DSpaceRestRepository repository = this.utils.getResourceRepository(apiCategory, model);
        RestAddressableModel modelObject = null;
        try {
            modelObject = repository.upload(request, apiCategory, model, id, uploadfile);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException("Error " + e.getMessage() + " uploading file to " + model + " with ID= " + id, e);
        }
        catch (AuthorizeException ae) {
            throw new RESTAuthorizationException(ae);
        }
        DSpaceResource result = (DSpaceResource)this.converter.toResource((RestModel)modelObject);
        return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.CREATED, (HttpHeaders)new HttpHeaders(), (RepresentationModel)result);
    }

    @RequestMapping(method={RequestMethod.POST}, headers={"content-type=multipart/form-data"})
    public <T extends RestAddressableModel> ResponseEntity<RepresentationModel<?>> upload(HttpServletRequest request, @PathVariable String apiCategory, @PathVariable String model, @RequestParam(value="file") List<MultipartFile> uploadfile) throws SQLException, FileNotFoundException, IOException, AuthorizeException {
        this.checkModelPluralForm(apiCategory, model);
        DSpaceRestRepository repository = this.utils.getResourceRepository(apiCategory, model);
        Iterable content = repository.upload(request, uploadfile);
        ArrayList<DSpaceResource> resources = new ArrayList<DSpaceResource>();
        for (RestAddressableModel modelObject : content) {
            DSpaceResource result = (DSpaceResource)this.converter.toResource((RestModel)modelObject);
            resources.add(result);
        }
        return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.OK, (HttpHeaders)new HttpHeaders(), (RepresentationModel)CollectionModel.wrap(resources));
    }

    @RequestMapping(method={RequestMethod.PATCH}, value={"/{id:\\d+}"})
    public ResponseEntity<RepresentationModel<?>> patch(HttpServletRequest request, @PathVariable String apiCategory, @PathVariable String model, @PathVariable Integer id, @RequestBody(required=true) JsonNode jsonNode) {
        return this.patchInternal(request, apiCategory, model, (Serializable)id, jsonNode);
    }

    @RequestMapping(method={RequestMethod.PATCH}, value={"/{uuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}"})
    public ResponseEntity<RepresentationModel<?>> patch(HttpServletRequest request, @PathVariable String apiCategory, @PathVariable String model, @PathVariable(name="uuid") UUID id, @RequestBody(required=true) JsonNode jsonNode) {
        return this.patchInternal(request, apiCategory, model, (Serializable)id, jsonNode);
    }

    public <ID extends Serializable> ResponseEntity<RepresentationModel<?>> patchInternal(HttpServletRequest request, String apiCategory, String model, ID id, JsonNode jsonNode) {
        this.checkModelPluralForm(apiCategory, model);
        DSpaceRestRepository repository = this.utils.getResourceRepository(apiCategory, model);
        RestAddressableModel modelObject = null;
        try {
            JsonPatchConverter patchConverter = new JsonPatchConverter(this.mapper);
            Patch patch = patchConverter.convert(jsonNode);
            modelObject = repository.patch(request, apiCategory, model, id, patch);
        }
        catch (DSpaceBadRequestException | RepositoryMethodNotImplementedException | UnprocessableEntityException | ResourceNotFoundException e) {
            log.error(e.getMessage(), e);
            throw e;
        }
        DSpaceResource result = (DSpaceResource)this.converter.toResource((RestModel)modelObject);
        return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.OK, (HttpHeaders)new HttpHeaders(), (RepresentationModel)result);
    }

    private <ID extends Serializable> RepresentationModel findRelEntryInternal(HttpServletRequest request, HttpServletResponse response, String apiCategory, String model, String id, String rel, String relid, Pageable page, PagedResourcesAssembler assembler) throws Throwable {
        this.checkModelPluralForm(apiCategory, model);
        DSpaceRestRepository repository = this.utils.getResourceRepository(apiCategory, model);
        Class domainClass = repository.getDomainClass();
        LinkRest linkRest = this.utils.getClassLevelLinkRest(rel, domainClass);
        if (linkRest != null) {
            LinkRestRepository linkRepository = this.utils.getLinkResourceRepository(apiCategory, model, linkRest.name());
            Method linkMethod = this.utils.requireMethod(linkRepository.getClass(), "getResource");
            try {
                Object object = linkMethod.invoke((Object)linkRepository, request, id, relid, page, this.utils.obtainProjection());
                Link link = ((WebMvcLinkBuilder)((WebMvcLinkBuilder)((WebMvcLinkBuilder)WebMvcLinkBuilder.linkTo(this.getClass(), (Object[])new Object[]{apiCategory, model}).slash((Object)id)).slash((Object)rel)).slash((Object)relid)).withSelfRel();
                ArrayList<Object> result = new ArrayList<Object>();
                result.add(object);
                PageImpl pageResult = new PageImpl(result, page, 1L);
                Page halResources = pageResult.map(restObject -> this.converter.toResource((RestModel)restObject));
                return assembler.toModel(halResources, link);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof AccessDeniedException || e.getTargetException() instanceof ResourceNotFoundException) {
                    throw e.getTargetException();
                }
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return null;
    }

    private <ID extends Serializable> RepresentationModel findRelInternal(HttpServletRequest request, HttpServletResponse response, String apiCategory, String model, ID uuid, String subpath, Pageable page, PagedResourcesAssembler assembler) {
        this.checkModelPluralForm(apiCategory, model);
        DSpaceRestRepository repository = this.utils.getResourceRepository(apiCategory, model);
        Class domainClass = repository.getDomainClass();
        LinkRest linkRest = this.utils.getClassLevelLinkRest(subpath, domainClass);
        if (linkRest != null) {
            LinkRestRepository linkRepository = this.utils.getLinkResourceRepository(apiCategory, model, linkRest.name());
            Method linkMethod = this.utils.requireMethod(linkRepository.getClass(), linkRest.method());
            try {
                if (Page.class.isAssignableFrom(linkMethod.getReturnType())) {
                    Page pageResult = (Page)linkMethod.invoke((Object)linkRepository, request, uuid, page, this.utils.obtainProjection());
                    if (pageResult == null) {
                        log.error("Paged subresource link repository " + linkRepository.getClass() + " incorrectly returned null for request with id " + uuid);
                        response.setStatus(500);
                        return null;
                    }
                    Link link = null;
                    String querystring = request.getQueryString();
                    link = querystring != null && querystring.length() > 0 ? ((WebMvcLinkBuilder)((WebMvcLinkBuilder)WebMvcLinkBuilder.linkTo(this.getClass(), (Object[])new Object[]{apiCategory, model}).slash(uuid)).slash((Object)(subpath + "?" + querystring))).withSelfRel() : ((WebMvcLinkBuilder)((WebMvcLinkBuilder)WebMvcLinkBuilder.linkTo(this.getClass(), (Object[])new Object[]{apiCategory, model}).slash(uuid)).slash((Object)subpath)).withSelfRel();
                    return new EntityModel((Object)new EmbeddedPage(link.getHref(), pageResult.map(arg_0 -> ((ConverterService)this.converter).toResource(arg_0)), null, subpath), new Link[0]);
                }
                RestModel object = (RestModel)linkMethod.invoke((Object)linkRepository, request, uuid, page, this.utils.obtainProjection());
                if (object == null) {
                    response.setStatus(204);
                    return null;
                }
                Link link = ((WebMvcLinkBuilder)((WebMvcLinkBuilder)WebMvcLinkBuilder.linkTo(this.getClass(), (Object[])new Object[]{apiCategory, model}).slash(uuid)).slash((Object)subpath)).withSelfRel();
                HALResource tmpresult = this.converter.toResource(object);
                tmpresult.add(link);
                return tmpresult;
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        RestModel modelObject = repository.findById(uuid).orElse(null);
        if (modelObject == null) {
            throw new ResourceNotFoundException(apiCategory + "." + model + " with id: " + uuid + " not found");
        }
        DSpaceResource resource = (DSpaceResource)this.converter.toResource(modelObject);
        String rel = null;
        for (Link l : resource.getLinks()) {
            if (l.isTemplated()) {
                if (!l.getHref().substring(0, l.getHref().indexOf("?")).contentEquals(request.getRequestURL())) continue;
                rel = l.getRel().value();
                continue;
            }
            if (!l.getHref().contentEquals(request.getRequestURL())) continue;
            rel = l.getRel().value();
        }
        if (rel == null) {
            throw new ResourceNotFoundException(rel + " undefined for " + model);
        }
        if (resource.getLink(rel) == null) {
            throw new ResourceNotFoundException(rel + " undefined for " + model);
        }
        if (resource.getEmbeddedResources().get(rel) instanceof EmbeddedPage) {
            EmbeddedPage ep = (EmbeddedPage)resource.getEmbeddedResources().get(rel);
            List fullList = ep.getFullList();
            if (fullList == null || fullList.size() == 0) {
                PageImpl pageResult = new PageImpl(fullList, page, 0L);
                PagedModel result = assembler.toModel((Page)pageResult);
                return result;
            }
            int start = Math.toIntExact(page.getOffset());
            int end = start + page.getPageSize() > fullList.size() ? fullList.size() : start + page.getPageSize();
            DSpaceRestRepository resourceRepository = this.utils.getResourceRepository(((RestAddressableModel)fullList.get(0)).getCategory(), ((RestAddressableModel)fullList.get(0)).getType());
            PageImpl pageResult = new PageImpl(fullList.subList(start, end), page, (long)fullList.size());
            return assembler.toModel(pageResult.map(arg_0 -> ((ConverterService)this.converter).toResource(arg_0)));
        }
        if (resource.getEmbeddedResources().get(rel) == null) {
            response.setStatus(204);
        }
        return (RepresentationModel)resource.getEmbeddedResources().get(rel);
    }

    @RequestMapping(method={RequestMethod.GET})
    public <T extends RestAddressableModel> PagedModel<DSpaceResource<T>> findAll(@PathVariable String apiCategory, @PathVariable String model, Pageable page, PagedResourcesAssembler assembler, HttpServletResponse response, @RequestParam MultiValueMap<String, Object> parameters) {
        Page resources;
        String encodedParameterString = this.getEncodedParameterStringFromRequestParams(parameters);
        DSpaceRestRepository repository = this.utils.getResourceRepository(apiCategory, model);
        Link link = ((WebMvcLinkBuilder)WebMvcLinkBuilder.linkTo(this.getClass(), (Object[])new Object[]{apiCategory, model}).slash((Object)encodedParameterString)).withSelfRel();
        try {
            resources = repository.findAll(page).map(arg_0 -> ((ConverterService)this.converter).toResource(arg_0));
        }
        catch (PaginationException pe) {
            resources = new PageImpl(new ArrayList(), page, pe.getTotal());
        }
        PagedModel result = assembler.toModel(resources, link);
        if (this.repositoryUtils.haveSearchMethods(repository)) {
            result.add(((WebMvcLinkBuilder)WebMvcLinkBuilder.linkTo(this.getClass(), (Object[])new Object[]{apiCategory, model}).slash((Object)"search")).withRel("search"));
        }
        return result;
    }

    private void checkModelPluralForm(String apiCategory, String model) {
        if (StringUtils.equals((CharSequence)Utils.makeSingular((String)model), (CharSequence)model)) {
            throw new RepositoryNotFoundException(apiCategory, model);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/search"})
    public RepresentationModel listSearchMethods(@PathVariable String apiCategory, @PathVariable String model) {
        this.checkModelPluralForm(apiCategory, model);
        RepresentationModel root = new RepresentationModel();
        DSpaceRestRepository repository = this.utils.getResourceRepository(apiCategory, model);
        List searchMethods = this.repositoryUtils.listSearchMethods(repository);
        if (CollectionUtils.isEmpty((Collection)searchMethods)) {
            throw new RepositorySearchNotFoundException(model);
        }
        for (String name : searchMethods) {
            Link link = ((WebMvcLinkBuilder)((WebMvcLinkBuilder)WebMvcLinkBuilder.linkTo(this.getClass(), (Object[])new Object[]{apiCategory, model}).slash((Object)"search")).slash((Object)name)).withRel(name);
            root.add(link);
        }
        return root;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/search/{searchMethodName}"})
    public <T extends RestAddressableModel> RepresentationModel executeSearchMethods(@PathVariable String apiCategory, @PathVariable String model, @PathVariable String searchMethodName, HttpServletResponse response, Pageable pageable, Sort sort, PagedResourcesAssembler assembler, @RequestParam MultiValueMap<String, Object> parameters) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String encodedParameterString = this.getEncodedParameterStringFromRequestParams(parameters);
        Link link = ((WebMvcLinkBuilder)((WebMvcLinkBuilder)((WebMvcLinkBuilder)WebMvcLinkBuilder.linkTo(this.getClass(), (Object[])new Object[]{apiCategory, model}).slash((Object)"search")).slash((Object)searchMethodName)).slash((Object)encodedParameterString)).withSelfRel();
        DSpaceRestRepository repository = this.utils.getResourceRepository(apiCategory, model);
        boolean returnPage = false;
        Object searchResult = null;
        Method searchMethod = this.repositoryUtils.getSearchMethod(searchMethodName, repository);
        if (searchMethod == null) {
            if (this.repositoryUtils.haveSearchMethods(repository)) {
                throw new RepositorySearchMethodNotFoundException(model, searchMethodName);
            }
            throw new RepositorySearchNotFoundException(model);
        }
        searchResult = this.repositoryUtils.executeQueryMethod(repository, parameters, searchMethod, pageable, sort, assembler);
        returnPage = searchMethod.getReturnType().isAssignableFrom(Page.class);
        PagedModel result = null;
        if (!returnPage) {
            if (searchResult == null) {
                response.setStatus(204);
                return null;
            }
            return this.converter.toResource((RestModel)((RestAddressableModel)searchResult));
        }
        Object resources = searchResult == null ? new PageImpl(new ArrayList(), pageable, 0L) : ((Page)searchResult).map(arg_0 -> ((ConverterService)this.converter).toResource(arg_0));
        result = assembler.toModel((Page)resources, link);
        return result;
    }

    private String getEncodedParameterStringFromRequestParams(@RequestParam MultiValueMap<String, Object> parameters) {
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.newInstance();
        for (String key : parameters.keySet()) {
            if (StringUtils.equals((CharSequence)key, (CharSequence)"embed") || StringUtils.startsWith((CharSequence)key, (CharSequence)"embed.")) continue;
            uriComponentsBuilder.queryParam(key, (Collection)parameters.get((Object)key));
        }
        return uriComponentsBuilder.encode().build().toString();
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id:\\d+}"})
    public ResponseEntity<RepresentationModel<?>> delete(HttpServletRequest request, @PathVariable String apiCategory, @PathVariable String model, @PathVariable Integer id) throws HttpRequestMethodNotSupportedException {
        return this.deleteInternal(apiCategory, model, (Serializable)id);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{uuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}"})
    public ResponseEntity<RepresentationModel<?>> delete(HttpServletRequest request, @PathVariable String apiCategory, @PathVariable String model, @PathVariable UUID uuid) throws HttpRequestMethodNotSupportedException {
        return this.deleteInternal(apiCategory, model, (Serializable)uuid);
    }

    private <ID extends Serializable> ResponseEntity<RepresentationModel<?>> deleteInternal(String apiCategory, String model, ID id) {
        this.checkModelPluralForm(apiCategory, model);
        DSpaceRestRepository repository = this.utils.getResourceRepository(apiCategory, model);
        repository.deleteById(id);
        return ControllerUtils.toEmptyResponse((HttpStatus)HttpStatus.NO_CONTENT);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{uuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}"})
    public DSpaceResource<RestAddressableModel> put(HttpServletRequest request, @PathVariable String apiCategory, @PathVariable String model, @PathVariable UUID uuid, @RequestBody JsonNode jsonNode) {
        return this.putOneJsonInternal(request, apiCategory, model, (Serializable)uuid, jsonNode);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id:\\d+}"}, consumes={"application/json", "application/hal+json"})
    public DSpaceResource<RestAddressableModel> put(HttpServletRequest request, @PathVariable String apiCategory, @PathVariable String model, @PathVariable Integer id, @RequestBody(required=true) JsonNode jsonNode) {
        return this.putOneJsonInternal(request, apiCategory, model, (Serializable)id, jsonNode);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id:\\d+}"}, consumes={"text/uri-list"})
    public DSpaceResource<RestAddressableModel> put(HttpServletRequest request, @PathVariable String apiCategory, @PathVariable String model, @PathVariable Integer id) throws IOException {
        return this.putOneUriListInternal(request, apiCategory, model, (Serializable)id);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id:[0-9a-fA-F]{32}}"}, consumes={"application/json", "application/hal+json"})
    public DSpaceResource<RestAddressableModel> put(HttpServletRequest request, @PathVariable String apiCategory, @PathVariable String model, @PathVariable String id, @RequestBody(required=true) JsonNode jsonNode) {
        return this.putOneJsonInternal(request, apiCategory, model, (Serializable)((Object)id), jsonNode);
    }

    private <ID extends Serializable> DSpaceResource<RestAddressableModel> putOneJsonInternal(HttpServletRequest request, String apiCategory, String model, ID id, JsonNode jsonNode) {
        this.checkModelPluralForm(apiCategory, model);
        DSpaceRestRepository repository = this.utils.getResourceRepository(apiCategory, model);
        RestAddressableModel modelObject = null;
        modelObject = repository.put(request, apiCategory, model, id, jsonNode);
        if (modelObject == null) {
            throw new ResourceNotFoundException(apiCategory + "." + model + " with id: " + id + " not found");
        }
        return (DSpaceResource)this.converter.toResource((RestModel)modelObject);
    }

    private <ID extends Serializable> DSpaceResource<RestAddressableModel> putOneUriListInternal(HttpServletRequest request, String apiCategory, String model, ID id) throws IOException {
        this.checkModelPluralForm(apiCategory, model);
        DSpaceRestRepository repository = this.utils.getResourceRepository(apiCategory, model);
        RestAddressableModel modelObject = null;
        List stringList = this.utils.getStringListFromRequest(request);
        modelObject = repository.put(request, apiCategory, model, id, stringList);
        if (modelObject == null) {
            throw new ResourceNotFoundException(apiCategory + "." + model + " with id: " + id + " not found");
        }
        return (DSpaceResource)this.converter.toResource((RestModel)modelObject);
    }
}

