/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canManageVersions", description="It can be used to verify if the user can create/delete or update the version of an Item")
public class CanManageVersionsFeature
implements AuthorizationFeature {
    public static final String NAME = "canManageVersions";
    @Autowired
    private ItemService itemService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private ConfigurationService configurationService;

    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        if (object instanceof ItemRest) {
            boolean isEnabled = this.configurationService.getBooleanProperty("versioning.enabled", true);
            if (!isEnabled || Objects.isNull(context.getCurrentUser())) {
                return false;
            }
            Item item = (Item)this.itemService.find(context, UUID.fromString(((ItemRest)object).getUuid()));
            if (Objects.nonNull(item)) {
                boolean isBlockEntity = this.configurationService.getBooleanProperty("versioning.block.entity", true);
                boolean hasEntityType = StringUtils.isNotBlank((String)this.itemService.getMetadataFirstValue((DSpaceObject)item, "dspace", "entity", "type", "*"));
                if (isBlockEntity && hasEntityType) {
                    return false;
                }
                return this.authorizeService.isAdmin(context, (DSpaceObject)item);
            }
        }
        return false;
    }

    public String[] getSupportedTypes() {
        return new String[]{"core.item"};
    }
}

