/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.SiteRest;
import org.dspace.authorize.AuthorizeConfiguration;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canManageGroups", description="It can be used to verify if the current user can manage groups in any community or collection in the site")
public class ManageGroupsFeature
implements AuthorizationFeature {
    public static final String NAME = "canManageGroups";
    @Autowired
    private AuthorizeService authorizeService;

    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        if (object instanceof SiteRest) {
            if (this.authorizeService.isAdmin(context)) {
                return true;
            }
            if ((AuthorizeConfiguration.canCommunityAdminManagePolicies() || AuthorizeConfiguration.canCommunityAdminManageAdminGroup()) && this.authorizeService.isCommunityAdmin(context)) {
                return true;
            }
            if ((AuthorizeConfiguration.canCommunityAdminManageCollectionPolicies() || AuthorizeConfiguration.canCommunityAdminManageCollectionSubmitters() || AuthorizeConfiguration.canCommunityAdminManageCollectionWorkflows() || AuthorizeConfiguration.canCommunityAdminManageCollectionAdminGroup()) && this.authorizeService.isCollectionAdmin(context)) {
                return true;
            }
        }
        return false;
    }

    public String[] getSupportedTypes() {
        return new String[]{"core.site"};
    }
}

