/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.link.search;

import org.dspace.app.rest.DiscoveryRestController;
import org.dspace.app.rest.link.HalLinkFactory;
import org.dspace.app.rest.model.DiscoveryResultsRest;
import org.dspace.app.rest.model.FacetResultsRest;
import org.dspace.app.rest.model.SearchResultsRest;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class DiscoveryRestHalLinkFactory<T>
extends HalLinkFactory<T, DiscoveryRestController> {
    public UriComponentsBuilder buildSearchBaseLink(DiscoveryResultsRest data) {
        try {
            UriComponentsBuilder uriBuilder = this.uriBuilder((Object)((DiscoveryRestController)this.getMethodOn(new Object[0])).getSearchObjects(data.getQuery(), data.getDsoTypes(), data.getScope(), data.getConfiguration(), null, null));
            return this.addFilterParams(uriBuilder, data);
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected UriComponentsBuilder buildFacetBaseLink(FacetResultsRest data) {
        try {
            UriComponentsBuilder uriBuilder = this.uriBuilder((Object)((DiscoveryRestController)this.getMethodOn(new Object[0])).getFacetValues(data.getFacetEntry().getName(), data.getPrefix(), data.getQuery(), data.getDsoTypes(), data.getScope(), data.getConfiguration(), null, null));
            return this.addFilterParams(uriBuilder, (DiscoveryResultsRest)data);
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected UriComponentsBuilder buildSearchFacetsBaseLink(SearchResultsRest data) {
        try {
            UriComponentsBuilder uriBuilder = this.uriBuilder((Object)((DiscoveryRestController)this.getMethodOn(new Object[0])).getFacets(data.getQuery(), data.getDsoTypes(), data.getScope(), data.getConfiguration(), null, null));
            uriBuilder = this.addSortingParms(uriBuilder, (DiscoveryResultsRest)data);
            return this.addFilterParams(uriBuilder, (DiscoveryResultsRest)data);
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected UriComponentsBuilder addFilterParams(UriComponentsBuilder uriComponentsBuilder, DiscoveryResultsRest data) {
        if (uriComponentsBuilder != null && data != null && data.getAppliedFilters() != null) {
            for (SearchResultsRest.AppliedFilter filter : data.getAppliedFilters()) {
                uriComponentsBuilder.queryParam("f." + filter.getFilter(), new Object[]{filter.getValue() + "," + filter.getOperator()});
            }
        }
        return uriComponentsBuilder;
    }

    protected UriComponentsBuilder addSortingParms(UriComponentsBuilder uriComponentsBuilder, DiscoveryResultsRest data) {
        if (uriComponentsBuilder != null && data != null && data.getSort() != null) {
            uriComponentsBuilder.queryParam("sort", new Object[]{data.getSort().getBy() + "," + data.getSort().getOrder()});
        }
        return uriComponentsBuilder;
    }

    protected Class<DiscoveryRestController> getControllerClass() {
        return DiscoveryRestController.class;
    }
}

