/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.util.List;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.model.AuthorizationFeatureRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="authz.feature")
public class AuthorizationFeatureRestRepository
extends DSpaceRestRepository<AuthorizationFeatureRest, String> {
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    @Autowired
    protected ConverterService converter;

    public Class<AuthorizationFeatureRest> getDomainClass() {
        return AuthorizationFeatureRest.class;
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    public Page<AuthorizationFeatureRest> findAll(Context context, Pageable pageable) {
        return this.converter.toRestPage(this.authorizationFeatureService.findAll(), pageable, this.utils.obtainProjection());
    }

    @PreAuthorize(value="permitAll()")
    public AuthorizationFeatureRest findOne(Context context, String id) {
        AuthorizationFeature authzFeature = this.authorizationFeatureService.find(id);
        if (authzFeature != null) {
            return (AuthorizationFeatureRest)this.converter.toRest((Object)authzFeature, this.utils.obtainProjection());
        }
        return null;
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    @SearchRestMethod(name="resourcetype")
    public Page<AuthorizationFeatureRest> findByResourceType(@Parameter(value="type", required=true) String type, Pageable pageable) {
        List foundFeatures = this.authorizationFeatureService.findByResourceType(type);
        return this.converter.toRestPage(foundFeatures, pageable, this.utils.obtainProjection());
    }
}

