/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import java.util.Optional;
import java.util.UUID;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.discovery.SearchServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canManageMappings", description="It can be used to verify if mapped items can be listed, searched, added and removed")
public class CanManageMappingsFeature
implements AuthorizationFeature {
    public static final String NAME = "canManageMappings";
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private Utils utils;
    @Autowired
    private ItemService itemService;
    @Autowired
    private CollectionService collectionService;

    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        Collection collection;
        if (object instanceof CollectionRest && this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)(collection = (Collection)this.utils.getDSpaceAPIObjectFromRest(context, object)), 1) && this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)collection, 3)) {
            return true;
        }
        if (object instanceof ItemRest) {
            Item item = (Item)this.itemService.find(context, UUID.fromString(((ItemRest)object).getUuid()));
            if (!this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)item, 1)) {
                return false;
            }
            try {
                Optional<Collection> collections = this.collectionService.findCollectionsWithSubmit("", context, null, 0, Integer.MAX_VALUE).stream().filter(c -> !c.getID().equals(item.getOwningCollection().getID())).filter(c -> {
                    try {
                        return this.collectionService.canEditBoolean(context, c);
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }).findFirst();
                return collections.isPresent();
            }
            catch (SearchServiceException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return false;
    }

    public String[] getSupportedTypes() {
        return new String[]{"core.collection", "core.item"};
    }
}

