/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.authorization.AuthorizeServiceRestUtil;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.WorkspaceItemRest;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canDelete", description="It can be used to verify if specific content can be deleted/expunged")
public class DeleteFeature
implements AuthorizationFeature {
    public static final String NAME = "canDelete";
    @Autowired
    private AuthorizeServiceRestUtil authorizeServiceRestUtil;
    @Autowired
    private Utils utils;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private ContentServiceFactory contentServiceFactory;

    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        if (object instanceof BaseObjectRest) {
            if (object.getType().equals("workspaceitem")) {
                object = ((WorkspaceItemRest)object).getItem();
            }
            DSpaceObject dSpaceObject = (DSpaceObject)this.utils.getDSpaceAPIObjectFromRest(context, object);
            DSpaceObject parentObject = this.getParentObject(context, dSpaceObject);
            switch (object.getType()) {
                case "bitstream": {
                    return this.authorizeService.authorizeActionBoolean(context, context.getCurrentUser(), parentObject, 4, true) && this.authorizeService.authorizeActionBoolean(context, context.getCurrentUser(), dSpaceObject, 4, true);
                }
                case "item": {
                    return this.authorizeService.authorizeActionBoolean(context, context.getCurrentUser(), parentObject, 4, true) && this.authorizeServiceRestUtil.authorizeActionBoolean(context, object, DSpaceRestPermission.DELETE);
                }
            }
            if (parentObject != null) {
                return this.authorizeService.authorizeActionBoolean(context, context.getCurrentUser(), parentObject, 4, true);
            }
            return this.authorizeServiceRestUtil.authorizeActionBoolean(context, object, DSpaceRestPermission.DELETE);
        }
        return false;
    }

    private DSpaceObject getParentObject(Context context, DSpaceObject object) throws SQLException {
        DSpaceObject parentObject = this.contentServiceFactory.getDSpaceObjectService(object.getType()).getParentObject(context, object);
        if (object.getType() == 2 && parentObject == null) {
            Item item = (Item)object;
            parentObject = item.getOwningCollection();
            WorkspaceItem byItem = ContentServiceFactory.getInstance().getWorkspaceItemService().findByItem(context, item);
            if (byItem != null) {
                parentObject = byItem.getCollection();
            }
        }
        return parentObject;
    }

    public String[] getSupportedTypes() {
        return new String[]{"core.community", "core.collection", "core.item", "core.bundle", "core.bitstream", "submission.workspaceitem", "eperson.eperson", "eperson.group"};
    }
}

