/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.dspace.app.rest.model.SubmissionFormRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.util.DCInputSet;
import org.dspace.app.util.DCInputsReader;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="config.submissionform")
public class SubmissionFormRestRepository
extends DSpaceRestRepository<SubmissionFormRest, String> {
    private Map<Locale, DCInputsReader> inputReaders;
    private DCInputsReader defaultInputReader = new DCInputsReader();

    public SubmissionFormRestRepository() throws DCInputsReaderException {
        Locale[] locales = I18nUtil.getSupportedLocales();
        this.inputReaders = new HashMap();
        for (Locale locale : locales) {
            this.inputReaders.put(locale, new DCInputsReader(I18nUtil.getInputFormsFileName((Locale)locale)));
        }
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public SubmissionFormRest findOne(Context context, String submitName) {
        try {
            DCInputSet subConfs;
            Locale currentLocale = context.getCurrentLocale();
            DCInputsReader inputReader = (DCInputsReader)this.inputReaders.get(currentLocale);
            if (inputReader == null) {
                inputReader = this.defaultInputReader;
            }
            if ((subConfs = inputReader.getInputsByFormName(submitName)) == null) {
                return null;
            }
            return (SubmissionFormRest)this.converter.toRest((Object)subConfs, this.utils.obtainProjection());
        }
        catch (DCInputsReaderException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<SubmissionFormRest> findAll(Context context, Pageable pageable) {
        try {
            Locale currentLocale = context.getCurrentLocale();
            DCInputsReader inputReader = currentLocale != null ? (DCInputsReader)this.inputReaders.get(currentLocale) : this.defaultInputReader;
            long total = inputReader.countInputs();
            List subConfs = inputReader.getAllInputs(Integer.valueOf(pageable.getPageSize()), Integer.valueOf(Math.toIntExact(pageable.getOffset())));
            return this.converter.toRestPage(subConfs, pageable, total, this.utils.obtainProjection());
        }
        catch (DCInputsReaderException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public Class<SubmissionFormRest> getDomainClass() {
        return SubmissionFormRest.class;
    }

    public void reload() throws DCInputsReaderException {
        this.defaultInputReader = new DCInputsReader();
        Locale[] locales = I18nUtil.getSupportedLocales();
        this.inputReaders = new HashMap();
        for (Locale locale : locales) {
            this.inputReaders.put(locale, new DCInputsReader(I18nUtil.getInputFormsFileName((Locale)locale)));
        }
    }
}

