/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.VocabularyRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.utils.AuthorityUtils;
import org.dspace.content.Collection;
import org.dspace.content.MetadataField;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="submission.vocabulary")
public class VocabularyRestRepository
extends DSpaceRestRepository<VocabularyRest, String> {
    @Autowired
    private ChoiceAuthorityService cas;
    @Autowired
    private AuthorityUtils authorityUtils;
    @Autowired
    private CollectionService collectionService;
    @Autowired
    private MetadataFieldService metadataFieldService;

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public VocabularyRest findOne(Context context, String name) {
        ChoiceAuthority source = this.cas.getChoiceAuthorityByAuthorityName(name);
        return this.authorityUtils.convertAuthority(source, name, this.utils.obtainProjection());
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<VocabularyRest> findAll(Context context, Pageable pageable) {
        Set authoritiesName = this.cas.getChoiceAuthoritiesNames();
        ArrayList<VocabularyRest> results = new ArrayList<VocabularyRest>();
        Projection projection = this.utils.obtainProjection();
        for (String authorityName : authoritiesName) {
            ChoiceAuthority source = this.cas.getChoiceAuthorityByAuthorityName(authorityName);
            VocabularyRest result = this.authorityUtils.convertAuthority(source, authorityName, projection);
            results.add(result);
        }
        return this.utils.getPage(results, pageable);
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    @SearchRestMethod(name="byMetadataAndCollection")
    public VocabularyRest findByMetadataAndCollection(@Parameter(value="metadata", required=true) String metadataField, @Parameter(value="collection", required=true) UUID collectionUuid) {
        Collection collection = null;
        MetadataField metadata = null;
        String[] tokens = Utils.tokenize((String)metadataField);
        try {
            collection = (Collection)this.collectionService.find(this.obtainContext(), collectionUuid);
            metadata = this.metadataFieldService.findByElement(this.obtainContext(), tokens[0], tokens[1], tokens[2]);
        }
        catch (SQLException e) {
            throw new RuntimeException("A database error occurs retrieving the metadata and/or the collection information", e);
        }
        if (metadata == null) {
            throw new UnprocessableEntityException(metadataField + " is not a valid metadata");
        }
        if (collection == null) {
            throw new UnprocessableEntityException(collectionUuid + " is not a valid collection");
        }
        String authorityName = this.cas.getChoiceAuthorityName(tokens[0], tokens[1], tokens[2], collection);
        ChoiceAuthority source = this.cas.getChoiceAuthorityByAuthorityName(authorityName);
        return this.authorityUtils.convertAuthority(source, authorityName, this.utils.obtainProjection());
    }

    public Class<VocabularyRest> getDomainClass() {
        return VocabularyRest.class;
    }
}

